/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.PermissionSchemeAware;
import com.atlassian.jira.jelly.PermissionSchemeContextAccessor;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class PermissionSchemeContextAccessorImpl
implements PermissionSchemeAware,
PermissionSchemeContextAccessor {
    private final String[] requiredContextVariables = new String[]{"jelly.username", "jelly.permission.scheme.id"};
    private final Tag tag;
    private boolean hasPermissionScheme = false;
    private Long permissionSchemeId = null;

    public PermissionSchemeContextAccessorImpl(Tag tag) {
        this.tag = tag;
    }

    @Override
    public JellyContext getContext() {
        return this.tag.getContext();
    }

    @Override
    public void setPermissionScheme(Long schemeId) {
        this.setPreviousPermissionScheme();
        this.resetPermissionSchemeContext();
        this.setPermissionSchemeContext(schemeId);
    }

    @Override
    public void loadPreviousPermissionScheme() {
        if (this.hasPermissionScheme) {
            this.resetPermissionSchemeContext();
            this.setPermissionScheme(this.permissionSchemeId);
            this.hasPermissionScheme = false;
            this.permissionSchemeId = null;
        }
    }

    private void setPreviousPermissionScheme() {
        if (this.hasPermissionScheme()) {
            this.hasPermissionScheme = true;
            this.permissionSchemeId = this.getPermissionSchemeId();
        }
    }

    private void resetPermissionSchemeContext() {
        this.getContext().removeVariable("jelly.permission.scheme.id");
    }

    private void setPermissionSchemeContext(Long schemeId) {
        this.getContext().setVariable("jelly.permission.scheme.id", (Object)schemeId);
    }

    @Override
    public String[] getRequiredContextVariables() {
        return this.requiredContextVariables;
    }

    @Override
    public boolean hasPermissionScheme() {
        return this.getContext().getVariables().containsKey("jelly.permission.scheme.id");
    }

    @Override
    public Long getPermissionSchemeId() {
        return (Long)this.getContext().getVariable("jelly.permission.scheme.id");
    }

    @Override
    public GenericValue getPermissionScheme() {
        try {
            return ManagerFactory.getPermissionSchemeManager().getScheme(this.getPermissionSchemeId());
        }
        catch (GenericEntityException e) {
            return null;
        }
    }

    @Override
    public String getUsername() {
        return (String)this.getContext().getVariable("jelly.username");
    }

    @Override
    public User getUser() {
        return ManagerFactory.getUserManager().getUser(this.getUsername());
    }
}

