/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.IssueAware;
import com.atlassian.jira.jelly.IssueContextAccessor;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueContextAccessorImpl
implements IssueContextAccessor,
IssueAware {
    private static final Logger log = Logger.getLogger(IssueContextAccessorImpl.class);
    private boolean hasIssueId = false;
    private Long issueId = null;
    private final Tag tag;

    public IssueContextAccessorImpl(Tag tag) {
        this.tag = tag;
    }

    @Override
    public void setIssue(Long issueId) {
        this.setPreviousIssue();
        this.resetIssueContext();
        this.setIssueContext(issueId);
    }

    @Override
    public void setIssue(String issueKey) {
        this.setPreviousIssue();
        this.resetIssueContext();
        this.setIssueContext(issueKey);
    }

    @Override
    public void setIssue(GenericValue issue) {
        this.setPreviousIssue();
        this.resetIssueContext();
        this.setIssueContext(issue);
    }

    @Override
    public void loadPreviousIssue() {
        if (this.hasIssueId) {
            this.resetIssueContext();
            this.setIssueContext(this.issueId);
            this.hasIssueId = false;
            this.issueId = null;
        }
    }

    private void setPreviousIssue() {
        if (this.hasIssue()) {
            this.hasIssueId = true;
            this.issueId = this.getIssueId();
        }
    }

    private void resetIssueContext() {
        this.getContext().removeVariable("jelly.issue.id");
        this.getContext().removeVariable("jelly.issue.key");
    }

    private void setIssueContext(Long issueId) {
        GenericValue project = ComponentAccessor.getIssueManager().getIssue(issueId);
        this.setIssueContext(project);
    }

    private void setIssueContext(String issueKey) {
        try {
            GenericValue project = ComponentAccessor.getIssueManager().getIssue(issueKey);
            this.setIssueContext(project);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private void setIssueContext(GenericValue issue) {
        if (issue != null) {
            this.getContext().setVariable("jelly.issue.id", (Object)issue.getLong("id"));
            this.getContext().setVariable("jelly.issue.key", (Object)issue.getString("key"));
        }
    }

    @Override
    public JellyContext getContext() {
        return this.tag.getContext();
    }

    @Override
    public boolean hasIssue() {
        return this.getContext().getVariables().containsKey("jelly.issue.id");
    }

    @Override
    public Long getIssueId() {
        if (this.hasIssue()) {
            return (Long)this.getContext().getVariable("jelly.issue.id");
        }
        return null;
    }

    @Override
    public GenericValue getIssue() {
        return ComponentAccessor.getIssueManager().getIssue(this.getIssueId());
    }
}

