/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.IssueKeyComparator;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class SubTaskStatisticsMapper
implements LuceneFieldSorter {
    private static final Logger log = Logger.getLogger(SubTaskStatisticsMapper.class);
    private final IssueManager issueManager;

    public SubTaskStatisticsMapper(IssueManager issueManager) {
        this.issueManager = issueManager;
    }

    public String getDocumentConstant() {
        return "issue_subtasks";
    }

    public Object getValueFromLuceneField(String documentValue) {
        return this.issueManager.getIssue(new Long(documentValue));
    }

    public Comparator getComparator() {
        return IssueKeyComparator.COMPARATOR;
    }

    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubTaskStatisticsMapper that = (SubTaskStatisticsMapper)obj;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }
}

