/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.transformer.KickassUserSearchInput;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.UserSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KickassUserSearchInputTransformer
extends UserSearchInputTransformer {
    public KickassUserSearchInputTransformer(UserFieldSearchConstantsWithEmpty searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager, UserHistoryManager userHistoryManager) {
        super(searchConstants, userFitsNavigatorHelper, groupManager, userManager, userHistoryManager);
    }

    public KickassUserSearchInputTransformer(UserFieldSearchConstants searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager, UserHistoryManager userHistoryManager) {
        super(searchConstants, userFitsNavigatorHelper, groupManager, userManager, userHistoryManager);
    }

    @Override
    public void populateFromParams(User user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String paramName = this.searchConstants.getFieldUrlParameter();
        Set<KickassUserSearchInput> newValues = this.getFromParams(actionParams, paramName);
        fieldValuesHolder.put((Object)paramName, newValues);
        if (actionParams.containsKey("check_prev_" + paramName)) {
            Set<KickassUserSearchInput> prevValues = this.getFromParams(actionParams, "prev_" + paramName);
            this.updateUsedUsers(user, newValues, prevValues);
        }
    }

    private Set<KickassUserSearchInput> getFromParams(ActionParams actionParams, String paramName) {
        String[] params = actionParams.getValuesForKey(paramName);
        HashSet<KickassUserSearchInput> values = new HashSet<KickassUserSearchInput>();
        if (params != null) {
            for (String param : params) {
                String[] parts = param.split(":", 2);
                if (parts[0].equals("empty")) {
                    values.add(KickassUserSearchInput.empty());
                    continue;
                }
                if (parts[0].equals("group")) {
                    values.add(KickassUserSearchInput.group(parts[1]));
                    continue;
                }
                if (parts[0].equals("issue_current_user")) {
                    values.add(KickassUserSearchInput.currentUser());
                    continue;
                }
                if (!parts[0].equals("user")) continue;
                values.add(KickassUserSearchInput.user(parts[1]));
            }
        }
        return values;
    }

    private void updateUsedUsers(User remoteUser, Set<KickassUserSearchInput> newValues, Set<KickassUserSearchInput> prevValues) {
        for (KickassUserSearchInput input : Sets.difference(newValues, prevValues)) {
            User user;
            if (!input.isUser() || (user = this.userManager.getUser(input.getValue())) == null) continue;
            this.userHistoryManager.addUserToHistory(UserHistoryItem.USED_USER, remoteUser, user);
        }
    }

    @Override
    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    @Override
    public void populateFromQuery(User user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        if (query == null) {
            return;
        }
        List<TerminalClause> clauses = this.getMatchingClauses(this.searchConstants.getJqlClauseNames().getJqlFieldNames(), query);
        HashSet<KickassUserSearchInput> values = new HashSet<KickassUserSearchInput>();
        for (TerminalClause clause : clauses) {
            this.parseOperand(clause.getOperand(), values);
        }
        fieldValuesHolder.put((Object)this.searchConstants.getFieldUrlParameter(), values);
    }

    @Override
    public Clause getSearchClause(User user, FieldValuesHolder fieldValuesHolder) {
        ArrayList<Object> operands = new ArrayList<Object>();
        Collection values = (Collection)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        if (values != null) {
            for (KickassUserSearchInput value : values) {
                String name;
                if (value.isCurrentUser()) {
                    name = "currentUser";
                    operands.add(new FunctionOperand(name));
                } else if (value.isEmpty()) {
                    operands.add(EmptyOperand.EMPTY);
                } else if (value.isGroup()) {
                    name = "membersOf";
                    operands.add(new FunctionOperand(name, new String[]{value.getValue()}));
                }
                if (!value.isUser()) continue;
                operands.add(new SingleValueOperand(value.getValue()));
            }
        }
        if (!operands.isEmpty()) {
            String clauseName = this.searchConstants.getJqlClauseNames().getPrimaryName();
            return new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new MultiValueOperand(operands));
        }
        return null;
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        if (query == null || query.getWhereClause() == null) {
            return true;
        }
        SimpleNavigatorCollectorVisitor visitor = this.createSimpleNavigatorCollectorVisitor();
        Clause whereClause = query.getWhereClause();
        whereClause.accept((ClauseVisitor)visitor);
        List clauses = visitor.getClauses();
        if (clauses.size() == 0) {
            return true;
        }
        if (clauses.size() > 1 || !visitor.isValid()) {
            return false;
        }
        return this.checkClause((TerminalClause)clauses.get(0), user);
    }

    private boolean checkClause(TerminalClause clause, User user) {
        Operator operator = clause.getOperator();
        Operand operand = clause.getOperand();
        if (operand instanceof SingleValueOperand) {
            return this.checkSingleValueClause(operator, (SingleValueOperand)operand);
        }
        if (operand instanceof FunctionOperand) {
            return this.checkFunctionClause(operator, (FunctionOperand)operand, user);
        }
        if (operand instanceof MultiValueOperand) {
            return this.checkMultiValueClause(operator, (MultiValueOperand)operand, user);
        }
        return operand instanceof EmptyOperand && this.emptySelectFlag != null && (operator == Operator.EQUALS || operator == Operator.IS);
    }

    private boolean checkSingleValueClause(Operator operator, SingleValueOperand operand) {
        String value = operand.getStringValue();
        if (value == null) {
            value = operand.getLongValue().toString();
        }
        return operator == Operator.EQUALS && this.userFitsNavigatorHelper.checkUser(value) != null;
    }

    private boolean checkFunctionClause(Operator operator, FunctionOperand operand, User user) {
        if (operator == Operator.EQUALS && this.isCurrentUser(operand) && this.isUserLoggedIn(user)) {
            return true;
        }
        return operator == Operator.IN && this.isMembersOf(operand);
    }

    private boolean checkMultiValueClause(Operator operator, MultiValueOperand operand, User user) {
        for (Operand value : operand.getValues()) {
            boolean isCurrentUser;
            if (!(value instanceof SingleValueOperand ? !this.checkSingleValueClause(Operator.EQUALS, (SingleValueOperand)value) : (value instanceof FunctionOperand ? !(isCurrentUser = this.isUserLoggedIn(user) && this.isCurrentUser((FunctionOperand)value)) && !this.isMembersOf((FunctionOperand)value) : !(value instanceof EmptyOperand)))) continue;
            return false;
        }
        return true;
    }

    private void parseOperand(Operand operand, Collection<KickassUserSearchInput> values) {
        if (operand instanceof EmptyOperand) {
            values.add(KickassUserSearchInput.empty());
        } else if (operand instanceof SingleValueOperand) {
            this.parseSingleValueOperand((SingleValueOperand)operand, values);
        } else if (operand instanceof FunctionOperand) {
            this.parseFunctionOperand((FunctionOperand)operand, values);
        } else if (operand instanceof MultiValueOperand) {
            MultiValueOperand multiValueOperand = (MultiValueOperand)operand;
            for (Operand value : multiValueOperand.getValues()) {
                this.parseOperand(value, values);
            }
        }
    }

    private void parseSingleValueOperand(SingleValueOperand operand, Collection<KickassUserSearchInput> values) {
        String value = operand.getStringValue();
        if (value == null) {
            value = operand.getLongValue().toString();
        }
        if ((value = this.userFitsNavigatorHelper.checkUser(value)) != null) {
            values.add(KickassUserSearchInput.user(value));
        }
    }

    private void parseFunctionOperand(FunctionOperand operand, Collection<KickassUserSearchInput> values) {
        if (this.isCurrentUser(operand)) {
            values.add(KickassUserSearchInput.currentUser());
        } else if (this.isMembersOf(operand)) {
            values.add(KickassUserSearchInput.group((String)operand.getArgs().get(0)));
        }
    }

    private boolean isCurrentUser(FunctionOperand operand) {
        String name = "currentUser";
        return operand.getName().equalsIgnoreCase(name);
    }

    private boolean isMembersOf(FunctionOperand operand) {
        String name = "membersOf";
        return operand.getName().equalsIgnoreCase(name) && operand.getArgs().size() == 1;
    }
}

