/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.SearchContextRenderHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import webwork.action.Action;

public class KickassIssueTypeSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final Predicate SPECIAL_OPTION_PREDICATE = new Predicate(){

        public boolean evaluate(Object object) {
            String optionId = ((Option)object).getId();
            return "-2".equals(optionId) || "-3".equals(optionId);
        }
    };
    private final Comparator<Option> ISSUE_TYPE_OPTION_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option first, Option second) {
            return new CompareToBuilder().append((Object)first.getName(), (Object)second.getName()).toComparison();
        }
    };
    private final ConstantsManager constantsManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OptionSetManager optionSetManager;
    private final PermissionManager permissionManager;
    private final SubTaskManager subTaskManager;

    public KickassIssueTypeSearchRenderer(ApplicationProperties applicationProperties, ConstantsManager constantsManager, IssueTypeSchemeManager issueTypeSchemeManager, OptionSetManager optionSetManager, PermissionManager permissionManager, SimpleFieldSearchConstants searchConstants, String searcherNameKey, SubTaskManager subTaskManager, VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants, searcherNameKey);
        this.constantsManager = constantsManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.optionSetManager = optionSetManager;
        this.permissionManager = permissionManager;
        this.subTaskManager = subTaskManager;
    }

    public void addEditParameters(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, User user, Map<String, Object> velocityParameters) {
        List selectedOptions = (List)fieldValuesHolder.get((Object)"type");
        velocityParameters.put("selectedOptions", selectedOptions);
        Collection<Option> validOptions = this.getVisibleOptions(user, searchContext);
        velocityParameters.put("optionCSSClasses", this.getOptionCSSClasses(validOptions));
        Collection<Option> invalidOptions = this.getInvalidOptions(user, selectedOptions, validOptions);
        SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParameters);
        velocityParameters.putAll(this.processOptions(validOptions, invalidOptions));
        velocityParameters.put("invalidOptions", invalidOptions);
    }

    public void addViewParameters(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, User user, Map<String, Object> velocityParameters) {
        ArrayList<String> issueTypes = new ArrayList<String>();
        ArrayList<String> invalidIssueTypes = new ArrayList<String>();
        ArrayList issueTypeIds = new ArrayList((Collection)fieldValuesHolder.get((Object)"type"));
        Collection validOptionIds = Collections2.transform(this.getVisibleOptions(user, searchContext), (Function)new Function<Option, String>(){

            public String apply(Option option) {
                return option.getId();
            }
        });
        if (issueTypeIds != null) {
            String allSubtasks;
            String allStandard = "-2";
            if (issueTypeIds.contains(allStandard)) {
                issueTypeIds.remove(allStandard);
                issueTypes.add(this.getI18n(user).getText("common.filters.allstandardissuetypes"));
            }
            if (issueTypeIds.contains(allSubtasks = "-3")) {
                String name = this.getI18n(user).getText("common.filters.allsubtaskissuetypes");
                issueTypes.add(name);
                issueTypeIds.remove(allSubtasks);
                if (!this.subTaskManager.isSubTasksEnabled() || !validOptionIds.contains(allSubtasks)) {
                    invalidIssueTypes.add(name);
                }
            }
            if (!issueTypeIds.isEmpty()) {
                for (IssueConstant issueConstant : this.constantsManager.convertToConstantObjects("IssueType", issueTypeIds)) {
                    issueTypes.add(issueConstant.getNameTranslation());
                    if (validOptionIds.contains(issueConstant.getId())) continue;
                    invalidIssueTypes.add(issueConstant.getNameTranslation());
                }
            }
        }
        velocityParameters.put("invalidIssueTypes", invalidIssueTypes);
        velocityParameters.put("selectedIssueTypes", issueTypes);
        SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParameters);
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addEditParameters(fieldValuesHolder, searchContext, user, velocityParameters);
        return this.renderEditTemplate("issuetype-searcher-edit.vm", velocityParameters);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addViewParameters(fieldValuesHolder, searchContext, user, velocityParameters);
        return this.renderViewTemplate("issuetype-searcher-view.vm", velocityParameters);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forIssueType().getJqlClauseNames(), query);
    }

    private Collection<Option> getAllOptions(I18nHelper i18nHelper) {
        ArrayList<Option> allOptions = new ArrayList<Option>();
        allOptions.add((Option)new TextOption("-2", i18nHelper.getText("common.filters.allstandardissuetypes")));
        allOptions.add((Option)new TextOption("-3", i18nHelper.getText("common.filters.allsubtaskissuetypes")));
        allOptions.addAll(Collections2.transform((Collection)this.constantsManager.getAllIssueTypeObjects(), (Function)new Function<IssueConstant, Option>(){

            public Option apply(@Nullable IssueConstant input) {
                return new IssueConstantOption(input);
            }
        }));
        return allOptions;
    }

    private Collection<Option> getInvalidOptions(User user, Collection selectedOptions, Collection<Option> validOptions) {
        ArrayList<Option> invalidOptions = new ArrayList<Option>();
        if (selectedOptions != null) {
            for (Option option : this.getAllOptions(this.getI18n(user))) {
                if (validOptions.contains(option) || !selectedOptions.contains(option.getId())) continue;
                invalidOptions.add(option);
            }
        }
        return invalidOptions;
    }

    private Map<Option, String> getOptionCSSClasses(Collection<Option> options) {
        HashMap<Option, String> optionClassesMap = new HashMap<Option, String>();
        for (Option option : options) {
            Collection fieldConfigSchemes = this.issueTypeSchemeManager.getAllRelatedSchemes(option.getId());
            StringBuilder cssClasses = new StringBuilder();
            for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
                FieldConfig fieldConfig = fieldConfigScheme.getOneAndOnlyConfig();
                cssClasses.append(fieldConfig.getId()).append(" ");
            }
            optionClassesMap.put(option, cssClasses.toString());
        }
        return optionClassesMap;
    }

    protected Collection<Option> getOptionsInSearchContext(SearchContext searchContext, User user) {
        HashSet<Option> options = new HashSet<Option>();
        Collection<FieldConfig> fieldConfigs = this.getProjectFieldConfigs(this.getProjectsInSearchContext(searchContext, user));
        for (FieldConfig fieldConfig : fieldConfigs) {
            OptionSet optionSet = this.optionSetManager.getOptionsForConfig(fieldConfig);
            options.addAll(optionSet.getOptions());
        }
        return options;
    }

    protected Map<String, Object> getVelocityParams(User searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParameters = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        velocityParameters.put("isKickass", true);
        return velocityParameters;
    }

    private Collection<Option> getVisibleOptions(User user, SearchContext searchContext) {
        Collection subtaskOptions;
        I18nHelper i18nHelper = this.getI18n(user);
        ArrayList<Option> options = new ArrayList<Option>();
        Collection<Option> optionsInSearchContext = this.getOptionsInSearchContext(searchContext, user);
        options.add((Option)new TextOption("-2", i18nHelper.getText("common.filters.allstandardissuetypes")));
        options.addAll(CollectionUtils.select(optionsInSearchContext, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE));
        if (this.subTaskManager.isSubTasksEnabled() && (subtaskOptions = CollectionUtils.select(optionsInSearchContext, (Predicate)IssueConstantOption.SUB_TASK_OPTIONS_PREDICATE)).size() > 0) {
            options.addAll(subtaskOptions);
            options.add((Option)new TextOption("-3", i18nHelper.getText("common.filters.allsubtaskissuetypes")));
        }
        return options;
    }

    private Collection<FieldConfig> getProjectFieldConfigs(Collection<Project> projects) {
        HashSet<FieldConfig> fieldConfigs = new HashSet<FieldConfig>();
        for (Project project : projects) {
            fieldConfigs.add(this.issueTypeSchemeManager.getConfigScheme(project).getOneAndOnlyConfig());
        }
        return fieldConfigs;
    }

    private Collection<Project> getProjectsInSearchContext(SearchContext searchContext, User user) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Project project : this.permissionManager.getProjectObjects(10, user)) {
            boolean isVisibleProject = searchContext.isForAnyProjects() || searchContext.getProjectIds().contains(project.getId());
            if (!isVisibleProject) continue;
            projects.add(project);
        }
        return projects;
    }

    private Map<String, Object> processOptions(Collection<Option> validOptions, Collection<Option> invalidOptions) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Collection<Object> options = new TreeSet<Option>(this.ISSUE_TYPE_OPTION_COMPARATOR);
        options.addAll(validOptions);
        options.addAll(invalidOptions);
        result.put("specialOptions", CollectionUtils.select(options, (Predicate)this.SPECIAL_OPTION_PREDICATE));
        options = CollectionUtils.selectRejected(options, (Predicate)this.SPECIAL_OPTION_PREDICATE);
        result.put("standardOptions", CollectionUtils.select(options, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE));
        result.put("subtaskOptions", CollectionUtils.select(options, (Predicate)IssueConstantOption.SUB_TASK_OPTIONS_PREDICATE));
        return result;
    }
}

