/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;

public abstract class AbstractProjectConstantsRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    protected final SimpleFieldSearchConstantsWithEmpty searchConstants;
    private final FieldVisibilityManager fieldVisibilityManager;

    public AbstractProjectConstantsRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, SimpleFieldSearchConstantsWithEmpty searchConstants, String searcherNameKey) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants.getSearcherId(), searcherNameKey);
        this.searchConstants = searchConstants;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.isRelevantForQuery(this.searchConstants.getJqlClauseNames(), query);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return searchContext.isSingleProjectContext() && !this.getSelectListOptions(user, searchContext).isEmpty() && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.searchConstants.getFieldId(), searchContext, user);
    }

    abstract List<Option> getSelectListOptions(User var1, SearchContext var2);

    Collection<GenericProjectConstantsLabel> getSelectedObjects(FieldValuesHolder fieldValuesHolder, com.atlassian.jira.util.Function<String, GenericProjectConstantsLabel> function) {
        return this.getSelectedObjects((Collection)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter()), function);
    }

    <T> Collection<GenericProjectConstantsLabel> getSelectedObjects(Collection<T> selectedValues, com.atlassian.jira.util.Function<T, GenericProjectConstantsLabel> function) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            return CollectionUtil.transform(selectedValues, function);
        }
        return null;
    }

    Collection<GenericProjectConstantsLabel> filterDuplicateSelectedObjects(Collection<GenericProjectConstantsLabel> selectedObjects, final Collection<Option> validOptions) {
        return Collections2.transform((Collection)ImmutableSortedSet.copyOf(selectedObjects), (Function)new Function<GenericProjectConstantsLabel, GenericProjectConstantsLabel>(){

            public GenericProjectConstantsLabel apply(GenericProjectConstantsLabel label) {
                boolean valid = false;
                String name = label.getLabel();
                for (Option option : validOptions) {
                    if (!label.isSameAs(option)) continue;
                    name = option.getName();
                    valid = true;
                    break;
                }
                return new GenericProjectConstantsLabel(name, valid);
            }
        });
    }

    public static class GenericProjectConstantsLabel
    implements Comparable<GenericProjectConstantsLabel> {
        private final String browseUrl;
        private final String label;
        private final boolean valid;

        public GenericProjectConstantsLabel(String label) {
            this(label, null, true);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl) {
            this(label, browseUrl, true);
        }

        public GenericProjectConstantsLabel(String label, boolean valid) {
            this(label, null, valid);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl, boolean valid) {
            this.browseUrl = browseUrl;
            this.label = label;
            this.valid = valid;
        }

        public String getLabel() {
            return this.label;
        }

        public String getBrowseUrl() {
            return this.browseUrl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isSameAs(Option option) {
            String name = option.getName();
            return null == this.label ? null == name : this.label.equalsIgnoreCase(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericProjectConstantsLabel that = (GenericProjectConstantsLabel)o;
            return !(this.label == null ? that.label != null : !this.label.equalsIgnoreCase(that.label));
        }

        public int hashCode() {
            return this.label != null ? this.label.toLowerCase().hashCode() : 0;
        }

        @Override
        public int compareTo(GenericProjectConstantsLabel genericProjectConstantsLabel) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.getLabel(), genericProjectConstantsLabel.getLabel());
        }
    }
}

