/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import java.util.Date;
import java.util.Map;

public abstract class DateQuickSearchHandler
extends SingleWordQuickSearchHandler {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    protected DateQuickSearchHandler(DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        String prefix = this.getPrefix();
        if (word == null || word.length() <= prefix.length() || !word.startsWith(prefix)) {
            return null;
        }
        word = word.substring(prefix.length());
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_PICKER);
        String datePickerToday = dateTimeFormatter.format(new Date());
        String datePickerTomorrow = dateTimeFormatter.format(new Date(System.currentTimeMillis() + 86400000L));
        String datePickerAfterTomorrow = dateTimeFormatter.format(new Date(System.currentTimeMillis() + 172800000L));
        String datePickerYesterday = dateTimeFormatter.format(new Date(System.currentTimeMillis() - 86400000L));
        String paramName = this.getSearchParamName();
        String paramAfter = paramName + ":after";
        String paramBefore = paramName + ":before";
        String paramPrevious = paramName + ":previous";
        String paramNext = paramName + ":next";
        if ("today".equals(word)) {
            return EasyMap.build((Object)paramAfter, (Object)datePickerToday, (Object)paramBefore, (Object)datePickerTomorrow);
        }
        if ("yesterday".equals(word)) {
            return EasyMap.build((Object)paramAfter, (Object)datePickerYesterday, (Object)paramBefore, (Object)datePickerToday);
        }
        if ("tomorrow".equals(word)) {
            return EasyMap.build((Object)paramAfter, (Object)datePickerToday, (Object)paramBefore, (Object)datePickerAfterTomorrow);
        }
        if (word.indexOf(44) != -1) {
            String firstTerm = word.substring(0, word.indexOf(44));
            String secondTerm = word.substring(word.indexOf(44) + 1);
            return EasyMap.build((Object)paramPrevious, (Object)firstTerm, (Object)paramNext, (Object)secondTerm);
        }
        return EasyMap.build((Object)paramPrevious, (Object)word);
    }

    protected abstract String getPrefix();

    protected abstract String getSearchParamName();
}

