/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comparator.CustomFieldComparators;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.issue.fields.CustomFieldImpl;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;

@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="TODO Needs to be fixed.")
public class DefaultCustomFieldManager
implements CustomFieldManager {
    private static final Logger log = Logger.getLogger(DefaultCustomFieldManager.class);
    private final PluginAccessor pluginAccessor;
    private final OfBizDelegator delegator;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FieldConfigContextPersister contextPersister;
    private final FieldScreenManager fieldScreenManager;
    private final RendererManager rendererManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final NotificationSchemeManager notificationSchemeManager;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;
    private final EventPublisher eventPublisher;
    private final CustomFieldDescription customFieldDescription;
    private final I18nHelper.BeanFactory i18nFactory;
    private final FeatureManager featureManager;
    private final ResettableLazyReference<CopyOnWriteCustomFieldCache> customFieldCacheResettableLazyReference = new ResettableLazyReference<CopyOnWriteCustomFieldCache>(){

        protected CopyOnWriteCustomFieldCache create() throws Exception {
            return new CopyOnWriteCustomFieldCache();
        }
    };

    public DefaultCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, FieldConfigSchemeManager fieldConfigSchemeManager, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, ProjectManager projectManager, PermissionManager permissionManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, RendererManager rendererManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, EventPublisher eventPublisher, CustomFieldDescription customFieldDescription, I18nHelper.BeanFactory i18nFactory, FeatureManager featureManager) {
        this.pluginAccessor = pluginAccessor;
        this.delegator = delegator;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.contextPersister = contextPersister;
        this.fieldScreenManager = fieldScreenManager;
        this.rendererManager = rendererManager;
        this.customFieldValuePersister = customFieldValuePersister;
        this.notificationSchemeManager = notificationSchemeManager;
        this.fieldManager = fieldManager;
        this.fieldConfigSchemeClauseContextUtil = fieldConfigSchemeClauseContextUtil;
        this.eventPublisher = eventPublisher;
        this.customFieldDescription = customFieldDescription;
        this.i18nFactory = i18nFactory;
        this.featureManager = featureManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public CustomField createCustomField(String fieldName, String description, CustomFieldType fieldType, CustomFieldSearcher customFieldSearcher, List contexts, List issueTypes) throws GenericEntityException {
        HashMap<String, String> createFields = new HashMap<String, String>();
        CopyOnWriteCustomFieldCache cache = this.getCustomFieldCache();
        createFields.put("name", StringUtils.abbreviate((String)fieldName, (int)254));
        createFields.put("customfieldtypekey", fieldType.getKey());
        if (StringUtils.isNotEmpty((String)description)) {
            createFields.put("description", description);
        }
        if (customFieldSearcher != null) {
            createFields.put("customfieldsearcherkey", customFieldSearcher.getDescriptor().getCompleteKey());
        }
        GenericValue customFieldGV = this.delegator.createValue("CustomField", createFields);
        CustomFieldImpl customField = new CustomFieldImpl(customFieldGV, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil, this.customFieldDescription, this.i18nFactory, this.featureManager);
        this.eventPublisher.publish((Object)new CustomFieldCreatedEvent((CustomField)customField));
        this.associateCustomFieldContext(customField, contexts, issueTypes);
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        genericDelegator.clearCacheLineFlexible((GenericEntity)new GenericPK(genericDelegator.getModelEntity("CustomField")));
        cache.add(customField);
        this.refreshConfigurationSchemes(customField.getIdAsLong());
        this.fieldManager.refresh();
        return this.getCustomFieldObject(customFieldGV.getLong("id"));
    }

    public void associateCustomFieldContext(CustomField customField, List contexts, List issueTypes) {
        if (contexts != null && !contexts.isEmpty()) {
            this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, contexts, issueTypes);
        }
    }

    public List getCustomFieldTypes() {
        ArrayList customFieldTypes = new ArrayList(this.pluginAccessor.getEnabledModulesByClass(CustomFieldType.class));
        Collections.sort(customFieldTypes, new Comparator<CustomFieldType>(){

            @Override
            public int compare(CustomFieldType o1, CustomFieldType o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null) {
                    return name2 == null ? 0 : -1;
                }
                return name1.compareTo(name2);
            }
        });
        return customFieldTypes;
    }

    public CustomFieldType getCustomFieldType(String key) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldTypeModuleDescriptor) {
            return (CustomFieldType)module.getModule();
        }
        log.error((Object)("Could not load custom field type plugin with key '" + key + "'. Is the plugin present and enabled?"));
        return null;
    }

    public List<CustomFieldSearcher> getCustomFieldSearchers(CustomFieldType customFieldType) {
        List allFieldSearchers = this.pluginAccessor.getEnabledModulesByClass(CustomFieldSearcher.class);
        ArrayList<CustomFieldSearcher> customFieldSearchers = new ArrayList<CustomFieldSearcher>();
        CustomFieldTypeModuleDescriptor customFieldTypeDescriptor = customFieldType.getDescriptor();
        for (CustomFieldSearcher searcher : allFieldSearchers) {
            if (!searcher.getDescriptor().getValidCustomFieldKeys().contains(customFieldType.getKey()) && !customFieldTypeDescriptor.getValidSearcherKeys().contains(searcher.getDescriptor().getCompleteKey())) continue;
            customFieldSearchers.add(searcher);
        }
        return customFieldSearchers;
    }

    public CustomFieldSearcher getCustomFieldSearcher(String key) {
        if (key == null) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldSearcherModuleDescriptor) {
            Class searcherClazz = module.getModuleClass();
            CustomFieldSearcher cfSearcher = (CustomFieldSearcher)JiraUtils.loadComponent(searcherClazz);
            cfSearcher.init((CustomFieldSearcherModuleDescriptor)module);
            return cfSearcher;
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    public Class getCustomFieldSearcherClass(String key) {
        if (key == null) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldSearcherModuleDescriptor) {
            return module.getModuleClass();
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    public void refreshConfigurationSchemes(Long customFieldId) {
        this.fieldConfigSchemeManager.init();
        this.getCustomFieldCache().refreshConfigurationSchemes(customFieldId);
    }

    public List<CustomField> getCustomFieldObjects(Issue issue) {
        return this.getCustomFieldObjects(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    public List<CustomField> getCustomFieldObjects(GenericValue issue) {
        return this.getCustomFieldObjects(issue.getLong("project"), issue.getString("type"));
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, String issueTypeId) {
        ArrayList issueTypes = issueTypeId == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeId});
        return this.getCustomFieldObjects(projectId, issueTypes);
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, List<String> issueTypeIds) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        Project project = this.projectManager.getProjectObj(projectId);
        issueTypeIds = this.constantsManager.expandIssueTypeIds(issueTypeIds);
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(project, issueTypeIds)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    public List<CustomField> getCustomFieldObjects(SearchContext searchContext) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(this.authenticationContext.getLoggedInUser(), searchContext)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    public CustomField getCustomFieldObject(Long id) {
        return this.getCustomFieldCache().getCustomFieldById(id);
    }

    public CustomField getCustomFieldObject(String key) {
        Long id = CustomFieldUtils.getCustomFieldId((String)key);
        if (id != null) {
            return this.getCustomFieldObject(id);
        }
        return null;
    }

    public CustomField getCustomFieldObjectByName(String customFieldName) {
        Collection<CustomField> values = this.getCustomFieldObjectsByName(customFieldName);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (values.size() > 1) {
            log.warn((Object)("Warning: returning 1 of " + values.size() + " custom fields named '" + customFieldName + "'"));
            if (log.isDebugEnabled()) {
                Thread.dumpStack();
            }
        }
        return this.getCustomFieldObjectsByName(customFieldName).iterator().next();
    }

    public Collection<CustomField> getCustomFieldObjectsByName(String customFieldName) {
        return this.getCustomFieldCache().getCustomFieldsByName(customFieldName);
    }

    public List<CustomField> getCustomFieldObjects() {
        return this.getAllCustomFields();
    }

    private List<CustomField> getAllCustomFields() {
        return this.getCustomFieldCache().getAllCustomFields();
    }

    public List<CustomField> getGlobalCustomFieldObjects() {
        Collection global = CollectionUtils.select(this.getAllCustomFields(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                CustomField cf = (CustomField)object;
                return cf.isGlobal();
            }
        });
        return new ArrayList<CustomField>(global);
    }

    public synchronized void refresh() {
        this.fieldConfigSchemeManager.init();
        this.customFieldCacheResettableLazyReference.reset();
        this.refreshSearchersAndIndexers();
    }

    private synchronized void refreshSearchersAndIndexers() {
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponentOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    public void clear() {
        this.customFieldCacheResettableLazyReference.reset();
        this.fieldManager.getFieldLayoutManager().refresh();
    }

    private List<GenericValue> getCustomFieldsFromDB() {
        ArrayList<GenericValue> customFields = new ArrayList<GenericValue>(this.delegator.findAll("CustomField"));
        Collections.sort(customFields, CustomFieldComparators.byGvName());
        return customFields;
    }

    public void removeCustomFieldPossiblyLeavingOrphanedData(Long customFieldId) throws RemoveException {
        Assertions.notNull((String)"id", (Object)customFieldId);
        CustomField originalCustomField = this.getCustomFieldObject(customFieldId);
        if (originalCustomField != null) {
            this.removeCustomField(originalCustomField);
        } else {
            log.debug((Object)("Couldn't load customfield object for id '" + customFieldId + "'.  Trying to lookup field directly via the db." + "  Please note that deleting a custom field this way may leave some custom field data behind."));
            GenericValue customFieldGv = this.delegator.findById("CustomField", customFieldId);
            if (customFieldGv != null) {
                log.debug((Object)("Customfield with id '" + customFieldId + "' retrieved successfully via the db."));
                String customFieldStringId = "customfield_" + customFieldId;
                this.removeCustomFieldAssociations(customFieldStringId);
                this.customFieldValuePersister.removeAllValues(customFieldStringId);
                try {
                    customFieldGv.remove();
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException("Error deleting custom field gv with id '" + customFieldId + "'", (Throwable)e);
                }
                this.fieldManager.refresh();
            } else {
                throw new IllegalArgumentException("Tried to remove custom field with id '" + customFieldId + "' that doesn't exist!");
            }
        }
    }

    public void removeCustomField(CustomField customField) throws RemoveException {
        this.removeCustomFieldAssociations(customField.getId());
        customField.remove();
        this.getCustomFieldCache().remove(customField);
        this.refreshSearchersAndIndexers();
        this.fieldManager.refresh();
    }

    private CopyOnWriteCustomFieldCache getCustomFieldCache() {
        return (CopyOnWriteCustomFieldCache)this.customFieldCacheResettableLazyReference.get();
    }

    private void removeCustomFieldAssociations(String customFieldId) throws RemoveException {
        this.fieldScreenManager.removeFieldScreenItems(customFieldId);
        this.delegator.removeByAnd("ColumnLayoutItem", EasyMap.build((Object)"fieldidentifier", (Object)customFieldId));
        this.delegator.removeByAnd("FieldLayoutItem", EasyMap.build((Object)"fieldidentifier", (Object)customFieldId));
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customFieldId);
        this.notificationSchemeManager.removeSchemeEntitiesForField(customFieldId);
    }

    public void removeCustomFieldValues(GenericValue issue) throws GenericEntityException {
        this.delegator.removeByAnd("CustomFieldValue", EasyMap.build((Object)"issue", (Object)issue.getLong("id")));
    }

    public void updateCustomField(CustomField customField) {
        customField.store();
        this.getCustomFieldCache().update(customField);
    }

    public CustomField getCustomFieldInstance(GenericValue customFieldGv) {
        return new CustomFieldImpl(customFieldGv, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil, this.customFieldDescription, this.i18nFactory, this.featureManager);
    }

    public void removeProjectAssociations(GenericValue project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    public void removeProjectAssociations(Project project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    public void removeProjectCategoryAssociations(ProjectCategory projectCategory) {
        this.contextPersister.removeContextsForProjectCategory(projectCategory);
        this.refresh();
    }

    class ImmutableCustomFieldCache
    extends CustomFieldCache {
        ImmutableCustomFieldCache(CustomFieldCache cache) {
            super((Map<Long, CustomField>)ImmutableMap.copyOf(cache.allCustomFieldObjectsMapById), (Multimap<String, CustomField>)ImmutableMultimap.copyOf(cache.allCustomFieldObjectsMapByName), (List<CustomField>)ImmutableList.copyOf(cache.allCustomFieldObjectsList));
        }
    }

    class CustomFieldCache {
        protected final Map<Long, CustomField> allCustomFieldObjectsMapById;
        protected final Multimap<String, CustomField> allCustomFieldObjectsMapByName;
        protected final List<CustomField> allCustomFieldObjectsList;

        protected CustomFieldCache(Map<Long, CustomField> allCustomFieldObjectsMapById, Multimap<String, CustomField> allCustomFieldObjectsMapByName, List<CustomField> allCustomFieldObjectsList) {
            this.allCustomFieldObjectsMapById = (Map)Preconditions.checkNotNull(allCustomFieldObjectsMapById);
            this.allCustomFieldObjectsMapByName = (Multimap)Preconditions.checkNotNull(allCustomFieldObjectsMapByName);
            this.allCustomFieldObjectsList = (List)Preconditions.checkNotNull(allCustomFieldObjectsList);
        }

        protected CustomFieldCache(CustomFieldCache cache) {
            this.allCustomFieldObjectsMapById = Maps.newHashMap(cache.allCustomFieldObjectsMapById);
            this.allCustomFieldObjectsMapByName = ArrayListMultimap.create(cache.allCustomFieldObjectsMapByName);
            this.allCustomFieldObjectsList = Lists.newArrayList(cache.allCustomFieldObjectsList);
        }

        protected CustomFieldCache() {
            this.allCustomFieldObjectsMapById = Maps.newHashMap();
            this.allCustomFieldObjectsMapByName = ArrayListMultimap.create();
            this.allCustomFieldObjectsList = Lists.newArrayList();
            if (DefaultCustomFieldManager.this.pluginAccessor.getPlugins().isEmpty()) {
                log.error((Object)"Attempting to Populate the Custom Fields cache in DefaultCustomFieldManager, however no plugins are loaded in the Plugin Manager.", (Throwable)new IllegalStateException("Plugin Manager not initialized."));
                return;
            }
            try {
                List customFields = DefaultCustomFieldManager.this.getCustomFieldsFromDB();
                if (customFields != null && !customFields.isEmpty()) {
                    for (GenericValue customFieldGv : customFields) {
                        CustomFieldImpl customFieldImpl = new CustomFieldImpl(customFieldGv, DefaultCustomFieldManager.this, DefaultCustomFieldManager.this.authenticationContext, DefaultCustomFieldManager.this.constantsManager, DefaultCustomFieldManager.this.fieldConfigSchemeManager, DefaultCustomFieldManager.this.permissionManager, DefaultCustomFieldManager.this.rendererManager, DefaultCustomFieldManager.this.fieldConfigSchemeClauseContextUtil, DefaultCustomFieldManager.this.customFieldDescription, DefaultCustomFieldManager.this.i18nFactory, DefaultCustomFieldManager.this.featureManager);
                        if (customFieldImpl.getCustomFieldType() == null) continue;
                        List configForCustomField = DefaultCustomFieldManager.this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customFieldImpl);
                        customFieldImpl.setConfigurationSchemes(configForCustomField);
                        this.allCustomFieldObjectsList.add(customFieldImpl);
                        this.allCustomFieldObjectsMapById.put(customFieldGv.getLong("id"), customFieldImpl);
                        this.allCustomFieldObjectsMapByName.put((Object)customFieldGv.getString("name"), (Object)customFieldImpl);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception thrown in DefaultCustomFieldManager.CustomFieldCache constructor");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        protected CustomField getCustomFieldById(Long id) {
            CustomField field = this.allCustomFieldObjectsMapById.get(id);
            return field != null ? new CustomFieldImpl(field) : null;
        }

        protected Collection<CustomField> getCustomFieldsByName(String customFieldName) {
            Collection customFields = this.allCustomFieldObjectsMapByName.get((Object)customFieldName);
            if (customFields == null) {
                return Collections.emptyList();
            }
            return this.cloneCustomFields(customFields);
        }

        protected List<CustomField> getAllCustomFields() {
            return this.cloneCustomFields(this.allCustomFieldObjectsList);
        }

        private List<CustomField> cloneCustomFields(Collection<CustomField> customFields) {
            if (customFields.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList customFieldClones = Lists.newArrayListWithCapacity((int)customFields.size());
            for (CustomField customField : customFields) {
                customFieldClones.add(new CustomFieldImpl(customField));
            }
            return customFieldClones;
        }

        protected void remove(CustomField customField) throws UnsupportedOperationException {
            CustomField cachedCustomField = this.allCustomFieldObjectsMapById.get(customField.getIdAsLong());
            this.allCustomFieldObjectsMapByName.remove((Object)cachedCustomField.getName(), (Object)cachedCustomField);
            this.allCustomFieldObjectsMapById.remove(customField.getIdAsLong());
            this.allCustomFieldObjectsList.remove(cachedCustomField);
        }

        protected void add(CustomField customField) throws UnsupportedOperationException {
            if (customField.getCustomFieldType() != null) {
                Preconditions.checkArgument((!this.allCustomFieldObjectsMapById.containsKey(customField.getIdAsLong()) ? 1 : 0) != 0, (Object)"cannot add the same custom field twice to the cache");
                this.allCustomFieldObjectsList.add(customField);
                Collections.sort(this.allCustomFieldObjectsList, CustomFieldComparators.byName());
                this.allCustomFieldObjectsMapByName.put((Object)customField.getName(), (Object)customField);
                this.allCustomFieldObjectsMapById.put(customField.getIdAsLong(), customField);
            }
        }

        private void update(CustomField customField) {
            CustomField cachedCustomField = this.getCustomFieldById(customField.getIdAsLong());
            if (customField.getCustomFieldSearcher() != cachedCustomField.getCustomFieldSearcher()) {
                DefaultCustomFieldManager.this.refreshSearchersAndIndexers();
            }
            if (!this.areConfigShemesEqual(customField.getConfigurationSchemes(), cachedCustomField.getConfigurationSchemes())) {
                DefaultCustomFieldManager.this.fieldManager.refresh();
            }
            this.remove(customField);
            this.add(customField);
        }

        protected void refreshConfigurationSchemes(Long fieldId) throws UnsupportedOperationException {
            CustomField field = this.allCustomFieldObjectsMapById.get(fieldId);
            if (field != null) {
                ((CustomFieldImpl)field).setConfigurationSchemes(DefaultCustomFieldManager.this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)field));
            }
        }

        private boolean areConfigShemesEqual(List<FieldConfigScheme> schemes, List<FieldConfigScheme> otherSchemes) {
            if (schemes != null && otherSchemes != null) {
                return HashMultiset.create(schemes).equals((Object)HashMultiset.create(schemes));
            }
            return false;
        }
    }

    private class CopyOnWriteCustomFieldCache {
        private transient ImmutableCustomFieldCache cache;

        public CopyOnWriteCustomFieldCache() {
            this.cache = this.makeImmutableCopyOf(new CustomFieldCache());
        }

        public synchronized void remove(CustomField customField) {
            CustomFieldCache cfCache = new CustomFieldCache(this.cache);
            cfCache.remove(customField);
            this.cache = this.makeImmutableCopyOf(cfCache);
        }

        public synchronized void add(CustomField customField) {
            CustomFieldCache cfCache = new CustomFieldCache(this.cache);
            cfCache.add(customField);
            this.cache = this.makeImmutableCopyOf(cfCache);
        }

        public synchronized void update(CustomField customField) {
            CustomFieldCache cfCache = new CustomFieldCache(this.cache);
            cfCache.update(customField);
            this.cache = this.makeImmutableCopyOf(cfCache);
        }

        public CustomField getCustomFieldById(Long id) {
            return this.cache.getCustomFieldById(id);
        }

        public Collection<CustomField> getCustomFieldsByName(String customFieldName) {
            return this.cache.getCustomFieldsByName(customFieldName);
        }

        public List<CustomField> getAllCustomFields() {
            return this.cache.getAllCustomFields();
        }

        public synchronized void refreshConfigurationSchemes(Long customFieldId) {
            this.cache.refreshConfigurationSchemes(customFieldId);
        }

        private ImmutableCustomFieldCache makeImmutableCopyOf(CustomFieldCache customFieldCache) {
            return new ImmutableCustomFieldCache(customFieldCache);
        }
    }
}

