/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class GermanAnalyzer
extends AbstractLanguageAnalyser {
    private final Set<?> stopSet = StopFilter.makeStopSet((String[])org.apache.lucene.analysis.de.GermanAnalyzer.GERMAN_STOP_WORDS);
    private final Version version;

    public GermanAnalyzer(Version version, boolean includeSubTokenFilter) {
        super(includeSubTokenFilter);
        this.version = version;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(this.version, reader);
        result = new StandardFilter(this.version, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.version, (TokenStream)result);
        result = new StopFilter(this.version, (TokenStream)result, this.stopSet);
        result = new GermanStemFilter((TokenStream)result);
        return result;
    }
}

