/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;

public interface IssueIndexer {
    public Index.Result indexIssues(@NotNull EnclosedIterable<Issue> var1, @NotNull Context var2);

    public Index.Result deindexIssues(@NotNull EnclosedIterable<Issue> var1, @NotNull Context var2);

    public Index.Result reindexIssues(@NotNull EnclosedIterable<Issue> var1, @NotNull Context var2, boolean var3, boolean var4, boolean var5);

    public Index.Result reindexComments(@NotNull Collection<Comment> var1, @NotNull Context var2);

    @GuardedBy(value="external indexing lock")
    public Index.Result indexIssuesBatchMode(@NotNull EnclosedIterable<Issue> var1, @NotNull Context var2);

    @GuardedBy(value="external indexing lock")
    public Index.Result optimize();

    public void deleteIndexes();

    public void shutdown();

    public IndexSearcher getIssueSearcher();

    public IndexSearcher getCommentSearcher();

    public IndexSearcher getChangeHistorySearcher();

    public List<String> getIndexPaths();

    public String getIndexRootPath();

    public static class Analyzers {
        public static final Analyzer SEARCHING = JiraAnalyzer.ANALYZER_FOR_SEARCHING;
        public static final Analyzer INDEXING = JiraAnalyzer.ANALYZER_FOR_INDEXING;
    }
}

