/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.AbstractDateRangeBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VersionDateRangeBuilder
extends AbstractDateRangeBuilder {
    private static final Logger log = Logger.getLogger(AbstractDateRangeBuilder.class);
    private final String fieldName;
    private final String emptyValue;
    private static final String EMPTY_STRING = "";
    private static final Class<Issue> issueClass = Issue.class;
    private final LazyReference<Map<String, VersionAccessor>> ref = new LazyReference<Map<String, VersionAccessor>>(){

        protected Map<String, VersionAccessor> create() throws Exception {
            return ImmutableMap.of((Object)"fixversion", (Object)new VersionAccessor(){

                @Override
                public Collection<Version> getVersions(Issue issue) {
                    return issue.getFixVersions();
                }
            }, (Object)"versions", (Object)new VersionAccessor(){

                @Override
                public Collection<Version> getVersions(Issue issue) {
                    return issue.getAffectedVersions();
                }
            });
        }
    };

    public VersionDateRangeBuilder(String fieldName, String emptyValue) {
        super(fieldName, emptyValue);
        this.fieldName = fieldName;
        this.emptyValue = emptyValue;
    }

    @Override
    protected ChangeHistoryItem createInitialChangeItem(Issue issue) {
        Collection<Version> currentVersions = ((VersionAccessor)((Map)this.ref.get()).get(this.fieldName)).getVersions(issue);
        String reporter = issue.getReporter() != null ? issue.getReporter().getName() : "issue_no_reporter";
        ChangeHistoryItem.Builder builder = new ChangeHistoryItem.Builder().withId(-1L).inChangeGroup(-1L).forIssue(issue.getId(), issue.getKey()).inProject(issue.getProjectObject().getId()).on(issue.getCreated()).field(this.fieldName).byUser(reporter);
        if (currentVersions.isEmpty()) {
            builder.to(EMPTY_STRING, this.emptyValue);
        } else {
            for (Version version : currentVersions) {
                builder.to(version.getName(), version.getId().toString());
            }
        }
        return builder.build();
    }

    private ChangeHistoryItem createChangeHistoryItem(Issue issue, Version version, boolean IncludeEmptyValue) {
        return new ChangeHistoryItem.Builder().forIssue(issue.getId(), issue.getKey()).on(issue.getCreated()).byUser(issue.getReporter().getName()).to(version.getName(), version.getId().toString()).field(this.fieldName).inProject(issue.getProjectObject().getId()).withId(-1L).inChangeGroup(-1L).build();
    }

    private ChangeHistoryItem fixInitialChangeItemToValue(List<ChangeHistoryItem> items, ChangeHistoryItem initialChangeItem, Timestamp created) {
        HashMap newToValues = Maps.newHashMap((Map)initialChangeItem.getTos());
        newToValues.remove(this.emptyValue);
        for (ChangeHistoryItem item : Iterables.reverse(items)) {
            newToValues.putAll(item.getFroms());
            for (String key : item.getTos().keySet()) {
                newToValues.remove(key);
            }
        }
        if (newToValues.isEmpty()) {
            newToValues.put(this.emptyValue, EMPTY_STRING);
        }
        return new ChangeHistoryItem.Builder().fromChangeItemWithoutPreservingChanges(initialChangeItem).withTos((Map)newToValues).nextChangeOn(created).build();
    }

    @Override
    public List<ChangeHistoryItem> buildDateRanges(Issue issue, List<ChangeHistoryItem> items) {
        ArrayList changeItems = Lists.newArrayList();
        try {
            ChangeHistoryItem initialChangeItem = this.createInitialChangeItem(issue);
            if (items.isEmpty()) {
                changeItems.add(initialChangeItem);
            } else {
                ChangeHistoryItem fixedInitialItem = this.fixInitialChangeItemToValue(items, initialChangeItem, items.get(0).getCreated());
                changeItems.add(fixedInitialItem);
                Map previousItemToValues = fixedInitialItem.getTos();
                PeekingIterator iterator = Iterators.peekingIterator(items.iterator());
                while (iterator.hasNext()) {
                    ChangeHistoryItem nextItem = (ChangeHistoryItem)iterator.next();
                    Map removals = nextItem.getFroms();
                    Map additions = nextItem.getTos();
                    HashMap effectiveTos = Maps.newHashMap();
                    effectiveTos.putAll(previousItemToValues);
                    effectiveTos.putAll(additions);
                    effectiveTos.remove(this.emptyValue);
                    for (String key : removals.keySet()) {
                        effectiveTos.remove(key);
                    }
                    if (effectiveTos.isEmpty()) {
                        effectiveTos.put(this.emptyValue, EMPTY_STRING);
                    }
                    if (iterator.hasNext()) {
                        changeItems.add(new ChangeHistoryItem.Builder().fromChangeItem(nextItem).nextChangeOn(((ChangeHistoryItem)iterator.peek()).getCreated()).field(this.fieldName).withFroms(previousItemToValues).withTos((Map)effectiveTos).build());
                    } else {
                        changeItems.add(new ChangeHistoryItem.Builder().fromChangeItem(nextItem).field(this.fieldName).withFroms(previousItemToValues).withTos((Map)effectiveTos).build());
                    }
                    previousItemToValues = effectiveTos;
                }
            }
        }
        catch (NullPointerException npe) {
            log.warn((Object)String.format("The issue %s has serious data integrity issues", issue.getKey()), (Throwable)npe);
            return null;
        }
        return changeItems;
    }

    private static abstract class VersionAccessor {
        private VersionAccessor() {
        }

        public abstract Collection<Version> getVersions(Issue var1);
    }
}

