/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractUserFieldImpl;
import com.atlassian.jira.issue.fields.Assignees;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.AssigneeOptions;
import com.atlassian.jira.issue.fields.rest.AssigneeRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperation;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.AssigneeSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class AssigneeSystemField
extends AbstractUserFieldImpl
implements HideableField,
RestAwareField,
RestFieldOperations {
    private static final Logger log = Logger.getLogger(AssigneeSystemField.class);
    private static final String ASSIGNEE_NAME_KEY = "issue.field.assignee";
    public static final String AUTOMATIC_ASSIGNEE_STRING = "-automatic-";
    private final AssigneeStatisticsMapper assigneeStatisticsMapper;
    private final AssigneeResolver assigneeResolver;
    private final UserManager userManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final Assignees assignees;
    private final WebResourceManager webResourceManager;
    private final FeatureManager featureManager;

    public AssigneeSystemField(VelocityTemplatingEngine templatingEngine, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, AssigneeStatisticsMapper assigneeStatisticsMapper, AssigneeResolver assigneeResolver, AssigneeSearchHandlerFactory assigneeSearchHandlerFactory, UserManager userManager, WebResourceManager webResourceManager, FeatureManager featureManager, JiraBaseUrls jiraBaseUrls, Assignees assignees, UserHistoryManager userHistoryManager) {
        super("assignee", ASSIGNEE_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, assigneeSearchHandlerFactory, userHistoryManager);
        this.assigneeStatisticsMapper = assigneeStatisticsMapper;
        this.assigneeResolver = assigneeResolver;
        this.userManager = userManager;
        this.featureManager = featureManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.webResourceManager = webResourceManager;
        this.assignees = assignees;
    }

    private Map<String, Object> makeSoyRenderData(String currentAssigneeName, AssigneeOptions assigneeOptions, List<Project> projects, Issue issue, ActionDescriptor actionDescriptor) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("id", this.getId());
        field.put("name", this.getId());
        data.put("field", field);
        if (actionDescriptor != null) {
            data.put("actionDescriptorId", actionDescriptor.getId());
        }
        if (issue != null && issue.getKey() != null) {
            data.put("issueKey", issue.getKey());
        }
        if (currentAssigneeName != null && assigneeOptions.isInvalidAssigneeSelected()) {
            data.put("editValue", currentAssigneeName);
        }
        data.put("assigneeOptions", assigneeOptions);
        data.put("isLoggedInUserAssignable", assigneeOptions.isLoggedInUserAssignable());
        if (projects != null) {
            String projectKeys = StringUtils.join((Collection)Lists.transform(projects, (Function)new Function<Project, String>(){

                public String apply(Project project) {
                    return project.getKey();
                }
            }), (String)",");
            data.put("projectKeys", projectKeys);
        }
        return data;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        String currentAssigneeName = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("currentAssignee", currentAssigneeName);
        if (this.hasContext(operationContext, issue)) {
            if (this.useFrotherControl()) {
                AssigneeOptions assigneeOptions = this.assignees.optionsForFrotherControl(issue, this.extractActionDescriptor(operationContext), currentAssigneeName);
                List<Project> projects = Arrays.asList(issue.getProjectObject());
                velocityParams.put("soyRenderData", this.makeSoyRenderData(currentAssigneeName, assigneeOptions, projects, issue, this.extractActionDescriptor(operationContext)));
            } else {
                velocityParams.put("assigneeOptions", this.assignees.optionsForHtmlSelect(issue, this.extractActionDescriptor(operationContext)));
            }
            Map auiparams = (Map)velocityParams.get("auiparams");
            auiparams.put("controlHeaderId", "assignee-container");
            return this.renderTemplate("assignee-edit.vm", velocityParams);
        }
        this.webResourceManager.requireResource("jira.webresources:autocomplete");
        velocityParams.put("allowUnassigned", this.isUnassignedIssuesEnabled());
        return this.renderTemplate("assignee-edit-no-context.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(null, action, null, displayParameters);
        String currentAssigneeName = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("currentAssignee", currentAssigneeName);
        ActionDescriptor actionDescriptor = this.extractActionDescriptor((OperationContext)bulkEditBean);
        Collection<Issue> issues = this.getBulkEditIssues(bulkEditBean);
        boolean frotherAssignee = this.useFrotherControl();
        if (frotherAssignee) {
            AssigneeOptions assigneeOptions = this.assignees.bulkOptionsForFrotherControl(issues, this.extractActionDescriptor(operationContext));
            ArrayList<Project> projects = new ArrayList<Project>(this.getIssueProjects(issues));
            velocityParams.put("soyRenderData", this.makeSoyRenderData(currentAssigneeName, assigneeOptions, projects, null, this.extractActionDescriptor(operationContext)));
        } else {
            velocityParams.put("assigneeOptions", this.assignees.bulkOptionsForHtmlSelect(issues, actionDescriptor));
        }
        return this.renderTemplate("assignee-edit.vm", velocityParams);
    }

    private boolean useFrotherControl() {
        boolean on = this.featureManager.isEnabled("frother.assignee.field");
        boolean off = this.featureManager.isEnabled("no.frother.assignee.field");
        return on && !off;
    }

    private Set<Project> getIssueProjects(Collection<Issue> issues) {
        HashSet<Project> projects = new HashSet<Project>();
        for (Issue issue : issues) {
            projects.add(issue.getProjectObject());
        }
        return projects;
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        User assignee = issue.getAssignee();
        if (assignee != null) {
            velocityParams.put("assignee", assignee.getName());
        } else {
            velocityParams.put("assignee", null);
        }
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("assignee", value);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        velocityParams.put("userutils", new UserUtils());
        return this.renderTemplate("assignee-view.vm", velocityParams);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String assigneeId = (String)fieldValuesHolder.get(this.getId());
        if ("-2".equals(assigneeId)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("assign.error.invaliduser"), ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if ("-1".equals(assigneeId)) {
            errorCollectionToAddTo.addErrorCollection(this.assigneeResolver.validateDefaultAssignee(issue, fieldValuesHolder));
            return;
        }
        if (!this.hasPermission(issue, 13)) {
            errorCollectionToAddTo.addErrorMessage(i18n.getText("assign.error.no.permission"), ErrorCollection.Reason.FORBIDDEN);
            return;
        }
        if (assigneeId != null) {
            User assigneeUser = this.userManager.getUserObject(assigneeId);
            if (assigneeUser == null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("admin.errors.issues.user.does.not.exit", "'" + assigneeId + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!assigneeId.equals(issue.getAssigneeId()) && !ComponentAccessor.getPermissionManager().hasPermission(17, issue.getProjectObject(), assigneeUser)) {
                errorCollectionToAddTo.addError("assignee", i18n.getText("assign.error.user.cannot.be.assigned", "'" + assigneeId + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (!this.isUnassignedIssuesEnabled()) {
            log.info((Object)"Validation error: Issues must be assigned");
            errorCollectionToAddTo.addError("assignee", i18n.getText("assign.error.issues.unassigned"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isUnassignedIssuesEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowunassigned");
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            User assignee;
            String assigneeId = (String)this.getValueFromParams(fieldValueHolder);
            boolean addToHistory = true;
            if ("-1".equals(assigneeId)) {
                assignee = this.assigneeResolver.getDefaultAssigneeObject((Issue)issue, fieldValueHolder);
                addToHistory = false;
            } else {
                assignee = this.getUser(assigneeId);
            }
            issue.setAssignee(assignee);
            if (addToHistory) {
                this.addToUsedUserHistoryIfValueChanged(issue);
            }
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (!(this.hasValue(originalIssue) ? !this.getPermissionManager().hasPermission(17, targetIssue.getProjectObject(), originalIssue.getAssigneeUser()) : !this.isUnassignedIssuesEnabled())) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setAssignee(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getAssignee() != null;
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                User assignee = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, assignee.getName(), assignee.getDisplayName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            User currentAssignee = (User)currentValue;
            if (value != null) {
                User assignee = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), currentAssignee.getName(), currentAssignee.getDisplayName(), assignee.getName(), assignee.getDisplayName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentAssignee.getName(), currentAssignee.getDisplayName(), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    private User getUser(String assigneeId) {
        if (assigneeId != null) {
            User user = this.userManager.getUser(assigneeId);
            if (user == null) {
                throw new DataAccessException("Error while retrieving user with id '" + assigneeId + "'.");
            }
            return user;
        }
        return null;
    }

    private boolean hasContext(OperationContext operationContext, Issue issue) {
        return issue != null;
    }

    private Collection<Issue> getBulkEditIssues(BulkEditBean bulkEditBean) {
        Collection<Object> issues = "BulkMove".equals(bulkEditBean.getOperationName()) ? bulkEditBean.getTargetIssueObjects().values() : bulkEditBean.getSelectedIssues();
        return issues;
    }

    private ActionDescriptor extractActionDescriptor(OperationContext operationContext) {
        IssueOperation issueOperation = operationContext.getIssueOperation();
        if (issueOperation instanceof WorkflowIssueOperation) {
            return ((WorkflowIssueOperation)issueOperation).getActionDescriptor();
        }
        return null;
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 13);
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), "-1");
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        User assignee = issue.getAssignee();
        String assigneeName = assignee != null ? assignee.getName() : null;
        fieldValuesHolder.put(this.getId(), assigneeName);
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0 && TextUtils.stringSet((String)value[0])) {
            return value[0];
        }
        return null;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public Object getValueFromParams(Map params) {
        return params.get(this.getId());
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        String assignee = AUTOMATIC_ASSIGNEE_STRING.equals(stringValue) ? "-1" : stringValue;
        fieldValuesHolder.put(this.getId(), assignee);
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.assignee";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.assigneeStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        String assigneeUserId = null;
        try {
            assigneeUserId = issue.getAssigneeId();
        }
        catch (DataAccessException e) {
            log.debug((Object)"Error occurred retrieving assignee", (Throwable)e);
        }
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        if (assigneeUserId != null) {
            velocityParams.put("assigneeUsername", assigneeUserId);
        }
        return this.renderTemplate("assignee-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String autoCompleteUrl = fieldTypeInfoContext.getIssue() == null ? String.format("%s/rest/api/latest/user/assignable/search?project=%s&username=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getIssueContext().getProjectObject().getKey()) : String.format("%s/rest/api/latest/user/assignable/search?issueKey=%s&username=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getIssue().getKey());
        return new FieldTypeInfo(null, autoCompleteUrl);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"user", (String)"assignee");
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new AssigneeRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)UserJsonBean.shortBean((User)issue.getAssignee(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return new JsonData((Object)EasyMap.build((Object)"name", (Object)"-1"));
    }
}

