/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class Path
implements Serializable,
Comparable<Path> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private static final Pattern SLOSH_SPLIT_PATTERN = Pattern.compile("[/|\\\\]");
    private static final Map<String, String> componentCache = new WeakHashMap<String, String>();
    private final String[] path;
    private String stringRep = null;

    private Path(String[] comp) {
        this.path = this.canonicalize(comp);
    }

    public Path() {
        this.path = new String[0];
    }

    public Path(CharSequence path) {
        this.path = this.canonicalize(Path.split(path));
    }

    public Path(CharSequence path, boolean allowSloshes) {
        this.path = this.canonicalize(Path.split(path, allowSloshes));
    }

    public Path(Path path) {
        this.path = path.getComponents();
    }

    public Path(Path aParent, String aPath) {
        this.path = this.canonicalize(Path.join(aParent.getComponents(), Path.split(aPath)));
    }

    public Path(Path aParent, Path aPath) {
        this.path = this.canonicalize(Path.join(aParent.getComponents(), aPath.getComponents()));
    }

    public Path(Path aParent, String aPath, boolean allowSloshes) {
        this.path = this.canonicalize(Path.join(aParent.getComponents(), Path.split(aPath, allowSloshes)));
    }

    public Path(String aParent, Path aPath) {
        this.path = this.canonicalize(Path.join(Path.split(aParent), aPath.getComponents()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] canonicalize(String[] components) {
        for (int i = 0; i < components.length; ++i) {
            String component = components[i];
            String canonical = componentCache.get(component);
            if (canonical == null) {
                Map<String, String> map = componentCache;
                synchronized (map) {
                    componentCache.put(new String(component), component);
                    continue;
                }
            }
            components[i] = canonical;
        }
        return components;
    }

    public Path(List<String> start) {
        this(start.toArray(new String[start.size()]));
    }

    public Path getParent() {
        if (this.path.length == 0) {
            return this;
        }
        String[] comp = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, comp, 0, comp.length);
        return new Path(comp);
    }

    public String getPath() {
        if (this.stringRep == null) {
            StringBuilder buf = new StringBuilder();
            String sep = "";
            for (String path : this.path) {
                buf.append(sep).append(path);
                sep = "/";
            }
            this.stringRep = buf.toString();
        }
        return this.stringRep;
    }

    public String[] getComponents() {
        return this.path;
    }

    public Path[] getPathComponents() {
        Path[] paths = new Path[this.path.length + 1];
        for (int i = 0; i <= this.path.length; ++i) {
            String[] comp = new String[i];
            System.arraycopy(this.path, 0, comp, 0, i);
            paths[i] = new Path(comp);
        }
        return paths;
    }

    public boolean isAncestor(Path descendant) {
        if (descendant.equals(this)) {
            return false;
        }
        Path commonRoot = this.getCommonRoot(descendant);
        return commonRoot.equals(this);
    }

    public Path getCommonRoot(Path other) {
        int i;
        int limit = Math.min(this.path.length, other.path.length);
        for (i = 0; i < limit && this.path[i].equals(other.path[i]); ++i) {
        }
        if (i == 0) {
            return new Path("/");
        }
        String[] commonComponents = new String[i];
        System.arraycopy(this.path, 0, commonComponents, 0, i);
        return new Path(commonComponents);
    }

    public Path getStripTail(Path other) {
        if (this.path.length < other.path.length) {
            return null;
        }
        for (int i = 0; i < other.path.length; ++i) {
            if (this.path[this.path.length - i - 1].equals(other.path[other.path.length - i - 1])) continue;
            return null;
        }
        return this.getSubPath(this.path.length - other.path.length);
    }

    public Path getRelativePath(Path aStartPath) {
        return this.getRelativePath(aStartPath, true);
    }

    public Path getRelativePath(Path aStartPath, boolean caseSensitive) {
        List<String> start = Path.simplify(aStartPath.path);
        if (start.isEmpty()) {
            return this;
        }
        List<String> us = Path.simplify(this.path);
        while (start.size() > 0 && us.size() > 0 && this.isEqualFirstComponent(start, us, caseSensitive)) {
            start.remove(0);
            us.remove(0);
        }
        int nback = start.size();
        for (int i = 0; i < nback; ++i) {
            start.add("..");
            start.add("..");
        }
        start.addAll(us);
        return new Path(start).simplify();
    }

    private boolean isEqualFirstComponent(List<String> start, List<String> us, boolean caseSensitive) {
        String lhs = start.get(0);
        String rhs = us.get(0);
        if (!caseSensitive) {
            lhs = lhs.toLowerCase(Locale.US);
            rhs = rhs.toLowerCase(Locale.US);
        }
        return lhs.equals(rhs);
    }

    public String getName() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public String toString() {
        return this.getPath();
    }

    public Path simplify() {
        List<String> list = Path.simplify(this.path);
        return new Path(list.toArray(new String[list.size()]));
    }

    public boolean isAbove() {
        return this.path.length > 0 && this.path[0].equals("..");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path path = (Path)o;
        return Arrays.equals(this.path, path.path);
    }

    public int hashCode() {
        int result = 0;
        for (String s : this.path) {
            result += s.hashCode();
        }
        return result;
    }

    private static List<String> simplify(String[] aPath) {
        String s0;
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(aPath));
        for (int i = 0; i < path.size(); ++i) {
            String s1 = (String)path.get(i);
            if ("..".equals(s1) && i > 0) {
                String s02 = (String)path.get(i - 1);
                if ("..".equals(s02)) continue;
                path.remove(i--);
                path.remove(i--);
                continue;
            }
            if (!".".equals(s1)) continue;
            path.remove(i--);
        }
        if (path.size() == 1 && (s0 = (String)path.get(0)).length() == 0) {
            path.remove(0);
        }
        return path;
    }

    private static String[] join(String[] aLeft, String[] aRight) {
        String[] result = new String[aLeft.length + aRight.length];
        System.arraycopy(aLeft, 0, result, 0, aLeft.length);
        System.arraycopy(aRight, 0, result, aLeft.length, aRight.length);
        return result;
    }

    public static String join(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if (a.length() == 0) {
            return b;
        }
        if (b.length() == 0) {
            return a;
        }
        if (a.endsWith("/")) {
            a = a.substring(0, a.length() - 1);
        }
        if (b.startsWith("/")) {
            b = b.substring(1);
        }
        return a + "/" + b;
    }

    public static String[] split(CharSequence aPath) {
        return Path.split(aPath, false);
    }

    public static String[] split(CharSequence aPath, boolean allowSloshes) {
        if (aPath == null || aPath.length() == 0) {
            return new String[0];
        }
        if (aPath.length() > 0 && aPath.charAt(0) == '/') {
            aPath = aPath.subSequence(1, aPath.length());
        }
        if (aPath.length() == 0) {
            return new String[0];
        }
        Pattern splitPattern = allowSloshes ? SLOSH_SPLIT_PATTERN : SPLIT_PATTERN;
        return splitPattern.split(aPath);
    }

    public boolean isRoot() {
        return this.path.length == 0 || this.path.length == 1 && this.path[0].length() == 0;
    }

    public Path trimFirst() {
        return this.trimFirst(1);
    }

    public Path trimFirst(int n) {
        if (this.path.length == 0) {
            return this;
        }
        int newLen = this.path.length - n;
        if (newLen <= 0) {
            return new Path();
        }
        String[] p = new String[newLen];
        System.arraycopy(this.path, n, p, 0, p.length);
        return new Path(p);
    }

    public Path trimLast() {
        if (this.path.length == 0) {
            return this;
        }
        if (this.path.length == 1) {
            return new Path();
        }
        String[] p = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, p, 0, p.length);
        return new Path(p);
    }

    public String getComponent(int i) {
        return this.path[i];
    }

    public int numComponents() {
        return this.path.length;
    }

    public int getNumComponents() {
        return this.numComponents();
    }

    @Override
    public int compareTo(Path o) {
        if (o == null) {
            return -1;
        }
        String[] path = o.path;
        for (int i = 0; i < this.path.length && i < path.length; ++i) {
            String a = this.path[i];
            String b = path[i];
            int r = a.compareTo(b);
            if (r == 0) continue;
            return r;
        }
        if (this.path.length < path.length) {
            return -1;
        }
        if (path.length < this.path.length) {
            return 1;
        }
        return 0;
    }

    public static String parseName(String p) {
        int idx = p.lastIndexOf("/");
        if (idx == -1) {
            return p;
        }
        return p.substring(idx + 1);
    }

    public static String parseDir(String p) {
        int idx = p.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return p.substring(0, idx);
    }

    public Path abbreviate(int maxLength) {
        return this.abbreviateImpl((int)maxLength).path;
    }

    public Path[] abbreviatePathComponents(int maxLength) {
        List<Path> pc = this.abbreviateImpl((int)maxLength).pathComponents;
        return pc.toArray(new Path[pc.size()]);
    }

    private AbbrevResult abbreviateImpl(int maxLength) {
        String ellipses = "...";
        if (this.path.length <= 2) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        int len = this.getPath().length();
        if (len <= maxLength) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(this.path));
        ArrayList<Path> pathComponents = new ArrayList<Path>(Arrays.asList(this.getPathComponents()));
        int insertEllipsesAt = components.size() / 2;
        while (len > maxLength && components.size() > 2) {
            int midPoint = components.size() / 2;
            insertEllipsesAt = Math.min(insertEllipsesAt, midPoint);
            String s = components.remove(midPoint);
            pathComponents.remove(midPoint);
            len -= s.length() + 1;
        }
        components.add(insertEllipsesAt, "...");
        pathComponents.add(insertEllipsesAt, null);
        return new AbbrevResult(new Path(components), pathComponents);
    }

    public boolean hasPrefix(Path p) {
        return this.hasPrefix(p, true);
    }

    public boolean hasPrefix(Path p, boolean caseSensitive) {
        if (p.numComponents() > this.numComponents()) {
            return false;
        }
        for (int i = 0; i < p.path.length; ++i) {
            String p1 = p.path[i];
            String p0 = this.path[i];
            if (!caseSensitive) {
                p1 = p1.toLowerCase(Locale.US);
                p0 = p0.toLowerCase(Locale.US);
            }
            if (p1.equals(p0)) continue;
            return false;
        }
        return true;
    }

    public Path normalize() {
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(this.path));
        int i = 0;
        while (i < components.size()) {
            String component = (String)components.get(i);
            if (component.equals(".")) {
                components.remove(i);
                continue;
            }
            if (component.equals("..") && i != 0) {
                String previous = (String)components.get(i - 1);
                if (!previous.equals("..")) {
                    components.remove(i);
                    components.remove(i - 1);
                    --i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return new Path(components.toArray(new String[components.size()]));
    }

    public String getPath(boolean caseSensitive) {
        String normalized = caseSensitive ? this.getPath() : this.getPath().toLowerCase(Locale.US);
        return normalized;
    }

    public void toLowerCase() {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = this.path[i].toLowerCase();
        }
    }

    public Path getSubPath(int depth) {
        depth = Math.min(depth, this.path.length);
        String[] comps = new String[depth];
        System.arraycopy(this.path, 0, comps, 0, depth);
        return new Path(comps);
    }

    public Path getPathHead() {
        if (this.path.length == 0) {
            return this;
        }
        return new Path(this.path[0]);
    }

    public String getTail() {
        return this.trimFirst(1).getPath();
    }

    public Path getTailPath() {
        return this.trimFirst(1);
    }

    public String getExtension() {
        String file;
        int dot;
        String extn = null;
        if (this.path.length > 0 && (dot = (file = this.getComponent(this.path.length - 1)).lastIndexOf(".")) != -1 && dot != file.length() - 1) {
            extn = file.substring(dot + 1);
        }
        return extn;
    }

    private static class AbbrevResult {
        final Path path;
        final List<Path> pathComponents;

        public AbbrevResult(Path path, List<Path> pathComponents) {
            this.path = path;
            this.pathComponents = pathComponents;
        }
    }
}

