/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

public class Operations {
    public static Index.Operation newDelete(@NotNull Term term, @NotNull Index.UpdateMode mode) {
        return new Delete(term, mode);
    }

    public static Index.Operation newCreate(@NotNull Document document, @NotNull Index.UpdateMode mode) {
        return new Create(document, mode);
    }

    public static Index.Operation newCreate(@NotNull Collection<Document> documents, @NotNull Index.UpdateMode mode) {
        return new Create(documents, mode);
    }

    public static Index.Operation newUpdate(@NotNull Term term, @NotNull Document document, @NotNull Index.UpdateMode mode) {
        return new Update(term, document, mode);
    }

    public static Index.Operation newConditionalUpdate(@NotNull Term term, @NotNull Document document, @NotNull Index.UpdateMode mode, @NotNull String optimisticLockField) {
        return new ConditionalUpdate(term, document, mode, optimisticLockField);
    }

    public static Index.Operation newUpdate(@NotNull Term term, @NotNull Collection<Document> documents, @NotNull Index.UpdateMode mode) {
        return new Update(term, documents, mode);
    }

    public static Index.Operation newOptimize() {
        return new Optimize();
    }

    public static Index.Operation newCompletionDelegate(Index.Operation operation, Runnable completionJob) {
        return new Completion(operation, completionJob);
    }

    private Operations() {
        throw new AssertionError((Object)"cannot instantiate!");
    }

    static final class Completion
    extends Index.Operation {
        private final Runnable completionJob;
        private final Index.Operation delegate;

        public Completion(Index.Operation delegate, Runnable completionJob) {
            this.delegate = delegate;
            this.completionJob = completionJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void perform(Writer writer) throws IOException {
            try {
                this.delegate.perform(writer);
            }
            finally {
                this.completionJob.run();
            }
        }

        @Override
        Index.UpdateMode mode() {
            return this.delegate.mode();
        }
    }

    static final class Optimize
    extends Index.Operation {
        Optimize() {
        }

        @Override
        void perform(Writer writer) throws IOException {
            writer.optimize();
        }

        @Override
        Index.UpdateMode mode() {
            return Index.UpdateMode.BATCH;
        }
    }

    static final class ConditionalUpdate
    extends Index.Operation {
        private final Create create;
        private final Delete delete;
        private final String optimisticLockField;

        ConditionalUpdate(@NotNull Term term, @NotNull Document document, Index.UpdateMode mode, @NotNull String optimisticLockField) {
            this.optimisticLockField = optimisticLockField;
            this.create = new Create(document, mode);
            this.delete = new Delete(term, mode);
        }

        @Override
        void perform(Writer writer) throws IOException {
            writer.updateDocumentConditionally(this.delete.term, (Document)this.create.documents.get(0), this.optimisticLockField);
        }

        @Override
        Index.UpdateMode mode() {
            return this.create.mode();
        }
    }

    static final class Update
    extends Index.Operation {
        private final Delete delete;
        private final Create create;

        Update(@NotNull Term term, @NotNull Document document, Index.UpdateMode mode) {
            this.delete = new Delete(term, mode);
            this.create = new Create(document, mode);
        }

        Update(@NotNull Term term, @NotNull Collection<Document> documents, Index.UpdateMode mode) {
            this.delete = new Delete(term, mode);
            this.create = new Create(documents, mode);
        }

        @Override
        void perform(Writer writer) throws IOException {
            writer.updateDocuments(this.delete.term, this.create.documents);
        }

        @Override
        Index.UpdateMode mode() {
            return this.delete.mode();
        }
    }

    static final class Create
    extends Index.Operation {
        private final List<Document> documents;
        private final Index.UpdateMode mode;

        Create(@NotNull Document document, @NotNull Index.UpdateMode mode) {
            this.documents = Collections.unmodifiableList(new ArrayList<Document>(Arrays.asList((Document)Assertions.notNull((String)"document", (Object)document))));
            this.mode = (Index.UpdateMode)((Object)Assertions.notNull((String)"mode", (Object)((Object)mode)));
        }

        Create(@NotNull Collection<Document> documents, @NotNull Index.UpdateMode mode) {
            Assertions.notNull((String)"documents", documents);
            this.documents = Collections.unmodifiableList(new ArrayList<Document>(documents));
            this.mode = (Index.UpdateMode)((Object)Assertions.notNull((String)"mode", (Object)((Object)mode)));
        }

        @Override
        void perform(Writer writer) throws IOException {
            writer.addDocuments(this.documents);
        }

        @Override
        Index.UpdateMode mode() {
            return this.mode;
        }
    }

    static final class Delete
    extends Index.Operation {
        private final Term term;
        private final Index.UpdateMode mode;

        Delete(@NotNull Term term, @NotNull Index.UpdateMode mode) {
            this.term = (Term)Assertions.notNull((String)"term", (Object)term);
            this.mode = (Index.UpdateMode)((Object)Assertions.notNull((String)"mode", (Object)((Object)mode)));
        }

        @Override
        void perform(Writer writer) throws IOException {
            writer.deleteDocuments(this.term);
        }

        @Override
        Index.UpdateMode mode() {
            return this.mode;
        }
    }
}

