/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.imports.project.parser.AttachmentParserImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentFileValidatorHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(AttachmentFileValidatorHandler.class);
    private static final int MAX_WARNINGS = 20;
    private MessageSet messageSet;
    private final BackupProject backupProject;
    private final ProjectImportOptions projectImportOptions;
    private final BackupSystemInformation backupSystemInformation;
    private final I18nHelper i18nHelper;
    private AttachmentParser attachmentParser;
    private boolean projectAttachmentDirExists;
    private boolean maxWarningsExceeded;
    private int validAttachmentCount = 0;

    public AttachmentFileValidatorHandler(BackupProject backupProject, ProjectImportOptions projectImportOptions, BackupSystemInformation backupSystemInformation, I18nHelper i18nHelper) {
        this.backupProject = backupProject;
        this.projectImportOptions = projectImportOptions;
        this.backupSystemInformation = backupSystemInformation;
        this.i18nHelper = i18nHelper;
        this.messageSet = new MessageSetImpl();
        this.projectAttachmentDirExists = true;
        this.maxWarningsExceeded = false;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalAttachment externalAttachment;
        if (StringUtils.isNotEmpty((String)this.projectImportOptions.getAttachmentPath()) && "FileAttachment".equals(entityName) && (externalAttachment = this.getAttachmentParser().parse(attributes)) != null && this.backupProject.containsIssue(externalAttachment.getIssueId())) {
            if (!this.projectAttachmentDirExists) {
                this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.project.directory.does.not.exist", this.backupProject.getProject().getKey()));
                this.getValidationResults().addWarningMessageInEnglish("The provided attachment path does not contain a sub-directory called '" + this.backupProject.getProject().getKey() + "'. If you proceed with the import attachments will not be included.");
            } else {
                String fileAttachmentUrl = this.getAttachmentParser().getFileAttachmentUrl(externalAttachment, this.projectImportOptions.getAttachmentPath(), this.backupProject.getProject().getKey(), this.backupSystemInformation.getIssueKeyForId(externalAttachment.getIssueId()));
                File attachmentFile = new File(fileAttachmentUrl);
                if (attachmentFile.exists()) {
                    ++this.validAttachmentCount;
                } else {
                    log.warn((Object)("The attachment '" + externalAttachment.getFileName() + "' does not exist at '" + fileAttachmentUrl + "'. It will not be imported."));
                    if (this.getValidationResults().getWarningMessages().size() >= 20) {
                        this.maxWarningsExceeded = true;
                        this.messageSet = new MessageSetImpl();
                        this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.too.many.warnings"));
                    }
                    if (!this.maxWarningsExceeded) {
                        if (externalAttachment.getFileName() == null || externalAttachment.getFileName().length() == 0) {
                            this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.missing.filename", externalAttachment.getId(), fileAttachmentUrl));
                        } else {
                            this.getValidationResults().addWarningMessage(this.i18nHelper.getText("admin.project.import.attachment.does.not.exist", externalAttachment.getFileName(), fileAttachmentUrl));
                        }
                    }
                }
            }
        }
    }

    public MessageSet getValidationResults() {
        return this.messageSet;
    }

    public int getValidAttachmentCount() {
        return this.validAttachmentCount;
    }

    @Override
    public void startDocument() {
        File attachmentDirectory;
        if (StringUtils.isNotEmpty((String)this.projectImportOptions.getAttachmentPath()) && !(attachmentDirectory = new File(this.projectImportOptions.getAttachmentPath() + File.separator + this.backupProject.getProject().getKey())).exists()) {
            this.projectAttachmentDirExists = false;
        }
    }

    public AttachmentParser getAttachmentParser() {
        if (this.attachmentParser == null) {
            this.attachmentParser = new AttachmentParserImpl();
        }
        return this.attachmentParser;
    }

    @Override
    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentFileValidatorHandler that = (AttachmentFileValidatorHandler)o;
        if (this.attachmentParser != null ? !this.attachmentParser.equals(that.attachmentParser) : that.attachmentParser != null) {
            return false;
        }
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.backupSystemInformation != null ? !this.backupSystemInformation.equals(that.backupSystemInformation) : that.backupSystemInformation != null) {
            return false;
        }
        if (this.i18nHelper != null ? !this.i18nHelper.equals(that.i18nHelper) : that.i18nHelper != null) {
            return false;
        }
        if (this.messageSet != null ? !this.messageSet.equals(that.messageSet) : that.messageSet != null) {
            return false;
        }
        return !(this.projectImportOptions != null ? !this.projectImportOptions.equals(that.projectImportOptions) : that.projectImportOptions != null);
    }

    public int hashCode() {
        int result = this.messageSet != null ? this.messageSet.hashCode() : 0;
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        result = 31 * result + (this.projectImportOptions != null ? this.projectImportOptions.hashCode() : 0);
        result = 31 * result + (this.backupSystemInformation != null ? this.backupSystemInformation.hashCode() : 0);
        result = 31 * result + (this.i18nHelper != null ? this.i18nHelper.hashCode() : 0);
        result = 31 * result + (this.attachmentParser != null ? this.attachmentParser.hashCode() : 0);
        return result;
    }
}

