/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import com.atlassian.jira.mail.IssueMailQueueItem;
import com.atlassian.jira.mail.IssueMailQueueItemFactory;
import com.atlassian.jira.mail.UserMailQueueItem;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtilImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class MailListener
extends AbstractIssueEventListener
implements IssueEventListener,
UserEventListener {
    private static final Logger log = Logger.getLogger(MailListener.class);
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueMailQueueItemFactory issueMailQueueItemFactory;
    private final UserManager userManager;

    public MailListener(NotificationSchemeManager notificationSchemeManager, IssueMailQueueItemFactory issueMailQueueItemFactory, UserManager userManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueMailQueueItemFactory = issueMailQueueItemFactory;
        this.userManager = userManager;
    }

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    protected void sendNotification(IssueEvent event) {
        if (!event.isSendMail()) {
            return;
        }
        Project project = event.getProject();
        try {
            List schemeEntities = this.notificationSchemeManager.getNotificationSchemeEntities(project, event.getEventTypeId().longValue());
            this.addMailItems(schemeEntities, event);
        }
        catch (GenericEntityException e) {
            log.error((Object)("There was an error accessing the notification scheme for the project: " + project.getKey() + "."), (Throwable)e);
        }
    }

    protected void addMailItems(List<SchemeEntity> schemeEntities, IssueEvent event) throws GenericEntityException {
        HashSet allRecipients = Sets.newHashSet();
        for (SchemeEntity schemeEntity : schemeEntities) {
            Set schemeRecipients = this.notificationSchemeManager.getRecipients(event, schemeEntity);
            schemeRecipients.removeAll(allRecipients);
            if (schemeRecipients.isEmpty()) continue;
            allRecipients.addAll(schemeRecipients);
            long templateId = this.getTemplateManager().getTemplate(schemeEntity).getId();
            IssueMailQueueItem item = this.issueMailQueueItemFactory.getIssueMailQueueItem(event, templateId, schemeRecipients, schemeEntity.getType());
            this.getMailQueue().addItem((MailQueueItem)item);
        }
    }

    public void issueCreated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueAssigned(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueClosed(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueResolved(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueReopened(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueUpdated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueCommented(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueCommentDeleted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorkLogged(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueDeleted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueMoved(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueStarted(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueStopped(IssueEvent event) {
        this.sendNotification(event);
    }

    public void issueGenericEvent(IssueEvent event) {
        this.sendNotification(event);
    }

    public void customEvent(IssueEvent event) {
        this.sendNotification(event);
    }

    protected void sendUserMail(UserEvent event, String subject, String subjectKey, String template) {
        if (ImportUtils.isEnableNotifications()) {
            UserMailQueueItem item = new UserMailQueueItem(event, subject, subjectKey, template);
            this.getMailQueue().addItem((MailQueueItem)item);
        }
    }

    public void userSignup(UserEvent event) {
        if (Boolean.TRUE.equals(event.getParams().get(UserUtilImpl.SEND_EMAIL))) {
            this.sendUserMail(event, "Account signup", "template.user.signup.subject", "usersignup.vm");
        }
    }

    public void userCreated(UserEvent event) {
        if (Boolean.TRUE.equals(event.getParams().get(UserUtilImpl.SEND_EMAIL))) {
            if (this.userManager.canUpdateUserPassword(event.getUser())) {
                this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated.vm");
            } else {
                this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated-nopassword.vm");
            }
        }
    }

    public void userForgotPassword(UserEvent event) {
        this.sendUserMail(event, "Account password", "template.user.forgotpassword.subject", "forgotpassword.vm");
    }

    public void userForgotUsername(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.forgotusername.subject", "forgotusernames.vm");
    }

    public void userCannotChangePassword(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.cannotchangepassword.subject", "cannotchangepassword.vm");
    }

    public boolean isInternal() {
        return true;
    }

    public boolean isUnique() {
        return true;
    }

    public String getDescription() {
        return "For each user or issue event, generate an appropriate email, and send to the required participants.";
    }

    @VisibleForTesting
    MailQueue getMailQueue() {
        return ComponentAccessor.getMailQueue();
    }

    @VisibleForTesting
    TemplateManager getTemplateManager() {
        return (TemplateManager)ComponentAccessor.getComponent(TemplateManager.class);
    }
}

