/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.DelegatingGroupWithAttributes;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.db.DataAccessException;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizGroupDao
implements GroupDao {
    private final OfBizHelper ofBiz;
    private final DirectoryDao directoryDao;
    private final InternalMembershipDao membershipDao;
    private final ConcurrentMap<DirectoryEntityKey, OfBizGroup> groupCache = new ConcurrentHashMap<DirectoryEntityKey, OfBizGroup>();
    private static final Function<GenericValue, String> TO_GROUPNAME_FUNCTION = new Function<GenericValue, String>(){

        public String apply(GenericValue gv) {
            return gv.getString("groupName");
        }
    };
    private static final Function<GenericValue, OfBizGroup> TO_GROUP_FUNCTION = new Function<GenericValue, OfBizGroup>(){

        public OfBizGroup apply(GenericValue gv) {
            return OfBizGroup.from(gv);
        }
    };

    public OfBizGroupDao(DelegatorInterface genericDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao) {
        this.ofBiz = new OfBizHelper(genericDelegator);
        this.membershipDao = membershipDao;
        this.directoryDao = directoryDao;
        this.buildCache();
    }

    public void removeAllGroups(long directoryId, Set<String> groupNames) {
        for (String groupName : groupNames) {
            try {
                this.remove((Group)this.findByName(directoryId, groupName));
            }
            catch (GroupNotFoundException e) {}
        }
    }

    public OfBizGroup findByName(long directoryId, String name) throws GroupNotFoundException {
        OfBizGroup group = (OfBizGroup)this.groupCache.get(DirectoryEntityKey.getKeyPreserveCase(directoryId, name));
        if (group != null) {
            return group;
        }
        group = (OfBizGroup)this.groupCache.get(DirectoryEntityKey.getKey(directoryId, name));
        if (group == null) {
            throw new GroupNotFoundException(name);
        }
        return group;
    }

    private GenericValue findGroupGenericValue(Group group) throws GroupNotFoundException {
        return this.findGroup(((Group)Preconditions.checkNotNull((Object)group)).getDirectoryId(), group.getName());
    }

    private GenericValue findGroup(long directoryId, String name) throws GroupNotFoundException {
        GenericValue groupGenericValue = EntityUtil.getOnly(this.findGroups(PrimitiveMap.of("directoryId", directoryId, "lowerGroupName", this.toLowerCase(name))));
        if (groupGenericValue != null) {
            return groupGenericValue;
        }
        throw new GroupNotFoundException(name);
    }

    private List<GenericValue> findGroups(Map<String, Object> filter) {
        return this.ofBiz.findByAnd("Group", filter);
    }

    public GroupWithAttributes findByNameWithAttributes(long directoryId, String name) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroup(directoryId, name);
        List<GenericValue> attributesGenericValue = this.findAttributes(directoryId, groupGenericValue.getLong("id"));
        return new DelegatingGroupWithAttributes((Group)OfBizGroup.from(groupGenericValue), OfBizAttributesBuilder.toAttributes(attributesGenericValue));
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        BatchResult results = new BatchResult(groups.size());
        for (Group group : groups) {
            try {
                Group addedGroup = this.add(group);
                results.addSuccess((Object)addedGroup);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)group);
            }
        }
        return results;
    }

    public synchronized Group add(Group group) {
        return this.add(group, false);
    }

    public Group addLocal(Group group) {
        return this.add(group, true);
    }

    private synchronized Group add(Group group, boolean local) {
        Timestamp currentTimestamp = this.getCurrentTimestamp();
        Map<String, Object> groupEntity = GroupEntity.getData(group, currentTimestamp, currentTimestamp, local);
        GenericValue gvGroup = this.ofBiz.createValue("Group", groupEntity);
        OfBizGroup ofBizGroup = OfBizGroup.from(gvGroup);
        this.putGroupInCache(ofBizGroup);
        return ofBizGroup;
    }

    public synchronized Group update(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        groupGenericValue.set("active", (Object)BooleanUtils.toInteger((boolean)group.isActive()));
        groupGenericValue.set("updatedDate", (Object)this.getCurrentTimestamp());
        groupGenericValue.set("description", (Object)group.getDescription());
        groupGenericValue.set("lowerDescription", (Object)this.toLowerCase(group.getDescription()));
        this.storeGroup(groupGenericValue);
        OfBizGroup ofBizGroup = OfBizGroup.from(groupGenericValue);
        this.putGroupInCache(ofBizGroup);
        return ofBizGroup;
    }

    private Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private String toLowerCase(String value) {
        if (value == null) {
            return null;
        }
        return IdentifierUtils.toLowerCase((String)value);
    }

    private void storeGroup(GenericValue groupGenericValue) {
        this.ofBiz.store(groupGenericValue);
    }

    public Group rename(Group group, String newName) {
        throw new UnsupportedOperationException("Renaming groups is not supported!");
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        for (Map.Entry attribute : ((Map)Preconditions.checkNotNull(attributes)).entrySet()) {
            this.removeAttribute(group, (String)attribute.getKey());
            if (attribute.getValue() == null || ((Set)attribute.getValue()).isEmpty()) continue;
            this.storeAttributeValues(group, (String)attribute.getKey(), (Set)attribute.getValue());
        }
    }

    private void storeAttributeValues(Group group, String name, Set<String> values) throws GroupNotFoundException {
        for (String value : values) {
            if (!StringUtils.isNotEmpty((String)value)) continue;
            this.storeAttributeValue(group, name, value);
        }
    }

    private void storeAttributeValue(Group group, String name, String value) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        this.ofBiz.createValue("GroupAttribute", GroupAttributeEntity.getData(group.getDirectoryId(), groupGenericValue.getLong("id"), name, value));
    }

    private List<GenericValue> findAttributes(long directoryId, long groupId) {
        return this.ofBiz.findByAnd("GroupAttribute", PrimitiveMap.of("directoryId", directoryId, "groupId", groupId));
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        Preconditions.checkNotNull((Object)attributeName);
        GenericValue gv = this.findGroupGenericValue(group);
        this.ofBiz.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", (long)gv.getLong("id"), "name", attributeName));
    }

    public synchronized void remove(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        this.membershipDao.removeAllMembersFromGroup(group);
        this.membershipDao.removeAllGroupMemberships(group);
        this.ofBiz.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", groupGenericValue.getLong("id")));
        this.ofBiz.removeValue(groupGenericValue);
        this.groupCache.remove(DirectoryEntityKey.getKey((DirectoryEntity)group));
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        SearchRestriction searchRestriction = query.getSearchRestriction();
        EntityCondition baseCondition = new GroupEntityConditionFactory().getEntityConditionFor(searchRestriction);
        if (baseCondition == null) {
            return this.getAllGroupsFromCache(directoryId, query.getReturnType());
        }
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        entityConditions.add(baseCondition);
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        List<GenericValue> results = this.ofBiz.findByCondition("Group", (EntityCondition)entityCondition, null, Collections.singletonList("groupName"));
        ArrayList<Object> typedResults = new ArrayList<Object>(results.size());
        Function<GenericValue, T> valueFunction = this.getTransformer(query.getReturnType());
        for (GenericValue result : results) {
            typedResults.add(valueFunction.apply((Object)result));
        }
        return typedResults;
    }

    private <T> List<T> getAllGroupsFromCache(long directoryId, Class<T> returnType) {
        ArrayList<OfBizGroup> allGroups = new ArrayList<OfBizGroup>();
        for (OfBizGroup group : this.groupCache.values()) {
            if (group.getDirectoryId() != directoryId) continue;
            allGroups.add(group);
        }
        if (returnType.isAssignableFrom(String.class)) {
            Function<OfBizGroup, String> valueFunction = new Function<OfBizGroup, String>(){

                public String apply(OfBizGroup from) {
                    return from.getName();
                }
            };
            ArrayList<Object> typedResults = new ArrayList<Object>(allGroups.size());
            for (OfBizGroup group : allGroups) {
                typedResults.add(valueFunction.apply((Object)group));
            }
            return typedResults;
        }
        if (returnType.isAssignableFrom(OfBizGroup.class)) {
            return allGroups;
        }
        throw new IllegalArgumentException("Class type for return values ('" + returnType + "') is not 'String' or 'Group'");
    }

    private <T> Function<GenericValue, T> getTransformer(Class<T> returnType) {
        return returnType.equals(String.class) ? TO_GROUPNAME_FUNCTION : TO_GROUP_FUNCTION;
    }

    public synchronized void flushCache() {
        this.groupCache.clear();
        this.buildCache();
    }

    private void buildCache() {
        for (Directory directory : this.directoryDao.findAll()) {
            List<GenericValue> groupGenericValues = this.findGroups(PrimitiveMap.of("directoryId", directory.getId()));
            for (GenericValue groupGenericValue : groupGenericValues) {
                this.putGroupInCache((OfBizGroup)TO_GROUP_FUNCTION.apply((Object)groupGenericValue));
            }
        }
    }

    private void putGroupInCache(OfBizGroup group) {
        DirectoryEntityKey key = DirectoryEntityKey.getKey(group.getDirectoryId(), group.getName());
        this.groupCache.put(key, group);
    }
}

