/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.console.AbstractConsoleProvider;
import com.atlassian.util.concurrent.Assertions;
import java.io.Console;
import java.io.IOException;

public class DeviceConsoleProvider
extends AbstractConsoleProvider {
    private final Console console;

    public DeviceConsoleProvider(Console console) {
        this.console = (Console)Assertions.notNull((String)"console", (Object)console);
    }

    @Override
    public String readLine(String prompt) throws IOException {
        String line = this.console.readLine("%s> ", prompt != null ? prompt : "");
        if (line == null) {
            throw this.closed();
        }
        return line.trim();
    }

    @Override
    public String readPassword(String prompt) throws IOException {
        char[] line;
        char[] cArray = line = prompt != null ? this.console.readPassword("%s> ", prompt) : this.console.readPassword();
        if (line == null) {
            throw this.closed();
        }
        return new String(line).trim();
    }

    @Override
    public void println() {
        this.console.format("\n", new Object[0]);
    }

    @Override
    public void print(String text) {
        this.console.format("%s", text);
    }

    @Override
    public void println(String text) {
        this.console.format("%s\n", text);
    }

    @Override
    public void printErrorMessage(String errorMessage) {
        this.println("*** " + errorMessage);
    }

    @Override
    public void printErrorMessage(Throwable ex) {
        String message = ex.getMessage();
        this.printErrorMessage(message != null ? message : ex.toString());
    }

    @Override
    public void flush() {
        this.console.flush();
    }
}

