/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import webwork.config.ConfigurationInterface;

class CachingWebworkConfiguration
implements ConfigurationInterface {
    private final ConfigurationInterface delegate;
    private final ConcurrentMap<String, Object> cacheMap;
    private static final Set<String> UN_CACHEABLE_KEYS = new HashSet<String>();

    CachingWebworkConfiguration(ConfigurationInterface delegate) {
        Assertions.notNull((String)"delegate", (Object)delegate);
        this.delegate = delegate;
        this.cacheMap = new ConcurrentHashMap<String, Object>();
    }

    public Object getImpl(String key) throws IllegalArgumentException {
        Object value = this.cacheMap.get(key);
        if (value == null && this.isCacheable(key, value = this.delegate.getImpl(key))) {
            this.cacheMap.putIfAbsent(key, value);
        }
        return value;
    }

    private boolean isCacheable(String key, Object value) {
        if (value == null) {
            return false;
        }
        if (UN_CACHEABLE_KEYS.contains(key)) {
            return false;
        }
        return key.startsWith("webwork.");
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("JIRA never calls setImpl() and hence we wont support it here");
    }

    public Iterator listImpl() {
        return this.delegate.listImpl();
    }

    static {
        UN_CACHEABLE_KEYS.add("webwork.multipart.maxSize");
        UN_CACHEABLE_KEYS.add("webwork.i18n.encoding");
    }
}

