/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.GroupedMethodProfiler;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ProfilingComponentAdapter<T>
extends DecoratingComponentAdapter {
    private static final Logger log = Logger.getLogger(ProfilingComponentAdapter.class);
    private final AtomicReference<T> instanceReference = new AtomicReference();
    private final AtomicReference<T> profilingReference = new AtomicReference();

    public ProfilingComponentAdapter(ComponentAdapter delegate) {
        super(delegate);
    }

    public T getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instanceReference.get() == null) {
            Object componentInstance;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting component instance with key '" + this.getComponentKey() + "' and implementation class '" + this.getComponentImplementation() + "'."));
            }
            try {
                componentInstance = super.getComponentInstance();
            }
            catch (AmbiguousComponentResolutionException ex) {
                throw new PicoIntrospectionException("Error trying to instantiate " + this.getComponentImplementation() + ": " + ex.getMessage(), (Throwable)ex);
            }
            Object key = super.getComponentKey();
            if (key != null && key instanceof Class && ((Class)key).isInterface()) {
                Object profiledInstance = GroupedMethodProfiler.getProfiledObject(componentInstance);
                this.profilingReference.set(profiledInstance);
            } else {
                this.profilingReference.set(componentInstance);
            }
            this.instanceReference.set(componentInstance);
        }
        if (UtilTimerStack.isActive()) {
            return this.profilingReference.get();
        }
        return this.instanceReference.get();
    }
}

