/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.AbstractComponentAdaptor;
import com.atlassian.jira.config.component.InvocationSwitcher;
import com.atlassian.jira.config.component.SwitchingInvocationHandler;
import com.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;

public abstract class AbstractSwitchingInvocationAdaptor<T>
extends AbstractComponentAdaptor<T> {
    private final Class<T> enabledClass;
    private final Class<T> disabledClass;
    private final LazyReference<Object> componentReference = new LazyReference<Object>(){

        protected Object create() throws Exception {
            return Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{AbstractSwitchingInvocationAdaptor.this.interfaceClass}, AbstractSwitchingInvocationAdaptor.this.getHandler());
        }
    };

    public AbstractSwitchingInvocationAdaptor(Class<T> interfaceClass, Class<T> enabledClass, Class<T> disabledClass) {
        super(interfaceClass);
        this.enabledClass = enabledClass;
        this.disabledClass = disabledClass;
    }

    protected boolean isEnabled() {
        return this.getInvocationSwitcher().isEnabled();
    }

    @Override
    public Class<T> getComponentImplementation() {
        return this.isEnabled() ? this.enabledClass : this.disabledClass;
    }

    protected InvocationHandler getHandler() {
        Object enabled = this.container.getComponentInstance(this.enabledClass);
        Object disabled = this.container.getComponentInstance(this.disabledClass);
        return new SwitchingInvocationHandler(enabled, disabled, this.getInvocationSwitcher());
    }

    @Override
    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException {
        return this.componentReference.get();
    }

    protected abstract InvocationSwitcher getInvocationSwitcher();
}

