/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.scheme.distiller;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.scheme.distiller.SchemeDistillerService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.scheme.distiller.SchemeDistiller;
import com.atlassian.jira.scheme.distiller.SchemeRelationships;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultSchemeDistillerService
implements SchemeDistillerService {
    private static final Logger log = Logger.getLogger(DefaultSchemeDistillerService.class);
    private SchemeDistiller schemeDistiller;
    private SchemeManagerFactory schemeManagerFactory;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private SchemeFactory schemeFactory;

    public DefaultSchemeDistillerService(SchemeDistiller schemeDistiller, SchemeManagerFactory schemeManagerFactory, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, SchemeFactory schemeFactory) {
        this.schemeDistiller = schemeDistiller;
        this.schemeManagerFactory = schemeManagerFactory;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.schemeFactory = schemeFactory;
    }

    @Override
    public DistilledSchemeResults distillSchemes(User user, Collection schemes, ErrorCollection errorCollection) {
        if (this.hasAdminPermission(user)) {
            return this.schemeDistiller.distillSchemes(schemes);
        }
        errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        return null;
    }

    @Override
    public Scheme persistNewSchemeMappings(User user, DistilledSchemeResult distilledSchemeResult, ErrorCollection errorCollection) throws DataAccessException {
        if (this.hasAdminPermission(user)) {
            SimpleErrorCollection localErrorCollection = new SimpleErrorCollection();
            this.validateDistilledSchemeResultIntegrity(user, distilledSchemeResult, (ErrorCollection)localErrorCollection);
            if (!localErrorCollection.hasAnyErrors()) {
                return this.schemeDistiller.persistNewSchemeMappings(distilledSchemeResult);
            }
            errorCollection.addErrors(localErrorCollection.getErrors());
            errorCollection.addErrorMessages(localErrorCollection.getErrorMessages());
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
        return null;
    }

    private void validateDistilledSchemeResultIntegrity(User user, DistilledSchemeResult distilledSchemeResult, ErrorCollection errorCollection) {
        this.isValidNewSchemeName(user, null, distilledSchemeResult.getResultingSchemeTempName(), distilledSchemeResult.getType(), errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            StringBuilder originalSchemesWithErrors = new StringBuilder();
            for (Scheme originalScheme : distilledSchemeResult.getOriginalSchemes()) {
                String origSchemeError = this.validateOriginalSchemeNotAltered(originalScheme, distilledSchemeResult, errorCollection);
                if (origSchemeError == null) continue;
                if (originalSchemesWithErrors.length() != 0) {
                    originalSchemesWithErrors.append(", ");
                }
                originalSchemesWithErrors.append(origSchemeError);
            }
            if (originalSchemesWithErrors.length() > 0) {
                errorCollection.addError(distilledSchemeResult.getResultingSchemeTempName(), this.jiraAuthenticationContext.getI18nHelper().getText("admin.scheme.distiller.service.modified.original.schemes", "<strong>", originalSchemesWithErrors.toString(), "</strong>"));
            }
        }
    }

    private String validateOriginalSchemeNotAltered(Scheme originalScheme, DistilledSchemeResult distilledSchemeResult, ErrorCollection errorCollection) {
        String result = null;
        try {
            String type = distilledSchemeResult.getType();
            String origSchemeName = originalScheme.getName();
            GenericValue schemeGV = this.schemeManagerFactory.getSchemeManager(type).getScheme(origSchemeName);
            if (schemeGV != null) {
                Scheme schemeFromDb = this.schemeFactory.getSchemeWithEntitiesComparable(schemeGV);
                if (!(schemeFromDb.containsSameEntities(originalScheme) && this.stringsEquivalent(schemeFromDb.getName(), originalScheme.getName()) && this.stringsEquivalent(schemeFromDb.getDescription(), originalScheme.getDescription()))) {
                    result = origSchemeName;
                }
            } else {
                result = origSchemeName;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Unable to retrieve scheme from db.", (Throwable)e);
            result = originalScheme.getName();
        }
        return result;
    }

    private boolean stringsEquivalent(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 != null && string2 != null) {
            return string1.equals(string2);
        }
        return false;
    }

    @Override
    public SchemeRelationships getSchemeRelationships(User user, DistilledSchemeResults distilledSchemeResults, ErrorCollection errorCollection) {
        if (this.hasAdminPermission(user)) {
            return this.schemeDistiller.getSchemeRelationships(distilledSchemeResults);
        }
        errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        return null;
    }

    @Override
    public void isValidNewSchemeName(User user, String fieldName, String newSchemeName, String schemeType, ErrorCollection errorCollection) {
        if (this.hasAdminPermission(user)) {
            GenericValue newScheme = null;
            try {
                newScheme = this.schemeManagerFactory.getSchemeManager(schemeType).getScheme(newSchemeName);
            }
            catch (GenericEntityException e) {
                // empty catch block
            }
            if (newScheme != null) {
                if (fieldName != null) {
                    errorCollection.addError(fieldName, this.getText("admin.scheme.distiller.service.scheme.name.exists"));
                } else {
                    errorCollection.addErrorMessage(this.getText("admin.scheme.distiller.service.scheme.name.exists"));
                }
            }
        } else {
            errorCollection.addErrorMessage(this.getText("project.roles.service.error.admin.permission"));
        }
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private boolean hasAdminPermission(User currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }
}

