/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.util.VisibilityValidator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import org.apache.commons.lang.StringUtils;

public class DefaultVisibilityValidator
implements VisibilityValidator {
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;

    public DefaultVisibilityValidator(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, ProjectRoleManager projectRoleManager, GroupManager groupManager) {
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
    }

    public boolean isValidVisibilityData(JiraServiceContext jiraServiceContext, String i18nPrefix, Issue issue, String groupLevel, String roleLevelId) {
        boolean valid = true;
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        User currentUser = jiraServiceContext.getLoggedInUser();
        if (issue == null) {
            errorCollection.addErrorMessage(this.getText(i18nPrefix + ".service.error.issue.null"), ErrorCollection.Reason.VALIDATION_FAILED);
            valid = false;
        }
        boolean roleLevelIdNotBlank = StringUtils.isNotBlank((String)roleLevelId);
        boolean groupLevelNotBlank = StringUtils.isNotBlank((String)groupLevel);
        if ((groupLevelNotBlank || roleLevelIdNotBlank) && Users.isAnonymous((User)currentUser)) {
            errorCollection.addErrorMessage(this.getText(i18nPrefix + ".service.error.visibility.anonymous"), ErrorCollection.Reason.VALIDATION_FAILED);
            return false;
        }
        if (groupLevelNotBlank && roleLevelIdNotBlank) {
            valid = false;
            errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.visibility"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (groupLevelNotBlank) {
            if (!this.isGroupVisiblityEnabled()) {
                valid = false;
                errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.visibility.group"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!this.groupManager.groupExists(groupLevel)) {
                valid = false;
                errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.groupdoesnotexist", groupLevel), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!this.groupManager.isUserInGroup(currentUser.getName(), groupLevel)) {
                valid = false;
                errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.usernotingroup", groupLevel), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (roleLevelIdNotBlank) {
            if (!this.isProjectRoleVisiblityEnabled()) {
                valid = false;
                errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.visibility.role"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                valid = valid && this.isRoleLevelValid(jiraServiceContext, i18nPrefix, roleLevelId, issue);
            }
        }
        return valid;
    }

    public boolean isGroupVisiblityEnabled() {
        return this.applicationProperties.getOption("jira.comment.level.visibility.groups");
    }

    public boolean isProjectRoleVisiblityEnabled() {
        return true;
    }

    boolean isRoleLevelValid(JiraServiceContext jiraServiceContext, String i18nPrefix, String roleLevelId, Issue issue) {
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        User currentUser = jiraServiceContext.getLoggedInUser();
        boolean valid = true;
        try {
            ProjectRole projectRole = this.projectRoleManager.getProjectRole(new Long(roleLevelId));
            if (projectRole != null) {
                if (!this.projectRoleManager.isUserInProjectRole(currentUser, projectRole, issue.getProjectObject())) {
                    errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.usernotinrole", projectRole.getName()));
                    valid = false;
                }
            } else {
                errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.roledoesnotexist", roleLevelId));
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            errorCollection.addError("commentLevel", this.getText(i18nPrefix + ".service.error.roleidnotnumber"));
            valid = false;
        }
        return valid;
    }

    private String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

