/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.issuelink;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.issuelink.IssueLinkService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuelink.Direction;
import com.atlassian.jira.issue.issuelink.IssueLinks;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultIssueLinkService
implements IssueLinkService {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final UserHistoryManager userHistoryManager;

    public DefaultIssueLinkService(IssueLinkTypeManager issueLinkTypeManager, IssueManager issueManager, PermissionManager permissionManager, I18nHelper.BeanFactory beanFactory, IssueLinkManager issueLinkManager, UserHistoryManager userHistoryManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.beanFactory = beanFactory;
        this.issueLinkManager = issueLinkManager;
        this.userHistoryManager = userHistoryManager;
    }

    public Collection<com.atlassian.jira.issue.issuelink.IssueLinkType> getIssueLinkTypes() {
        return this.transformIssueLinkType(this.issueLinkTypeManager.getIssueLinkTypes());
    }

    public com.atlassian.jira.issue.issuelink.IssueLink getIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId) {
        final IssueLink rawIssueLink = this.issueLinkManager.getIssueLink(sourceId, destinationId, issueLinkTypeId);
        if (rawIssueLink == null) {
            return null;
        }
        return new com.atlassian.jira.issue.issuelink.IssueLink(){

            public Issue getSourceIssue() {
                return rawIssueLink.getSourceObject();
            }

            public Issue getDestinationIssue() {
                return rawIssueLink.getDestinationObject();
            }

            public com.atlassian.jira.issue.issuelink.IssueLinkType getIssueLinkType() {
                return DefaultIssueLinkService.this.transformIssueLinkType(rawIssueLink.getIssueLinkType());
            }
        };
    }

    public IssueLinkService.IssueLinkResult getIssueLinks(User user, Issue issue) {
        return this.getIssueLinks(user, issue, true);
    }

    public IssueLinkService.IssueLinkResult getIssueLinks(User user, Issue issue, boolean excludeSystemLinks) {
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 10);
        if (!errorCollection.hasAnyErrors()) {
            LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, user, excludeSystemLinks);
            Set linkTypes = linkCollection.getLinkTypes();
            HashMap outwardIssueLinksByName = Maps.newHashMap();
            for (IssueLinkType linkType : linkTypes) {
                String input = linkType.getName();
                List list = linkCollection.getOutwardIssues(input);
                if (list == null) continue;
                outwardIssueLinksByName.put(input, this.transformListToIssueLink(issue, list, linkType));
            }
            HashMap inwardsIssueLinksByName = Maps.newHashMap();
            for (IssueLinkType linkType : linkTypes) {
                String input = linkType.getName();
                List list = linkCollection.getInwardIssues(input);
                if (list == null) continue;
                inwardsIssueLinksByName.put(input, this.transformListToIssueLink(issue, list, linkType));
            }
            ArrayList allIssueLinks = Lists.newArrayList();
            for (List issueLinks : Iterables.concat(outwardIssueLinksByName.values(), inwardsIssueLinksByName.values())) {
                allIssueLinks.addAll(issueLinks);
            }
            return this.makeIssueLinkResult(errorCollection, issue, linkTypes, allIssueLinks, outwardIssueLinksByName, inwardsIssueLinksByName);
        }
        return this.makeIssueLinkResult(errorCollection, issue, Collections.<IssueLinkType>emptyList(), Collections.<com.atlassian.jira.issue.issuelink.IssueLink>emptyList(), Collections.<String, List<com.atlassian.jira.issue.issuelink.IssueLink>>emptyMap(), Collections.<String, List<com.atlassian.jira.issue.issuelink.IssueLink>>emptyMap());
    }

    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, String linkName, Collection<String> linkKeys) {
        com.atlassian.jira.issue.issuelink.IssueLinkType linkType = this.matchToIssueLinkType(linkName);
        if (null == linkType) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.name", linkName));
            return new IssueLinkService.AddIssueLinkValidationResult(user, (ErrorCollection)errors, null, null, null, null);
        }
        Direction direction = linkName.equals(linkType.getInward()) ? Direction.IN : Direction.OUT;
        return this.validateAddIssueLinks(user, issue, linkType, direction, linkKeys, true);
    }

    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, Long issueLinkTypeId, Direction direction, Collection<String> linkKeys, boolean excludeSystemLinks) {
        com.atlassian.jira.issue.issuelink.IssueLinkType linkType = this.resolveIssueLinkTypeById(issueLinkTypeId);
        if (null == linkType) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.id", (Object)issueLinkTypeId));
            return new IssueLinkService.AddIssueLinkValidationResult(user, (ErrorCollection)errors, null, null, null, null);
        }
        return this.validateAddIssueLinks(user, issue, linkType, direction, linkKeys, excludeSystemLinks);
    }

    private IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, com.atlassian.jira.issue.issuelink.IssueLinkType linkType, Direction direction, Collection<String> linkKeys, boolean excludeSystemLinks) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"linkKeys", linkKeys);
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 12);
        if (!errorCollection.hasAnyErrors()) {
            this.validateLinkInput(user, errorCollection, issue, linkType, linkKeys, excludeSystemLinks);
        }
        return new IssueLinkService.AddIssueLinkValidationResult(user, errorCollection, issue, linkType, direction, linkKeys);
    }

    public IssueLinkService.IssueLinkResult addIssueLinks(User user, IssueLinkService.AddIssueLinkValidationResult result) {
        Assertions.notNull((String)"result", (Object)result);
        if (!result.isValid()) {
            throw new IllegalStateException("Cannot add issue links with invalid validation result!");
        }
        com.atlassian.jira.issue.issuelink.IssueLinkType linkType = result.getLinkType();
        if (linkType == null) {
            throw new IllegalArgumentException("Cant find issue link type '" + result.getLinkType().getName() + "'");
        }
        Issue sourceIssue = result.getIssue();
        for (String targetIssueKey : result.getLinkKeys()) {
            MutableIssue destinationIssue = this.issueManager.getIssueObject(targetIssueKey);
            if (destinationIssue == null) {
                throw new IllegalArgumentException("Issue with key '" + targetIssueKey + "' no longer exists!");
            }
            try {
                if (result.getDirection() == Direction.OUT) {
                    this.issueLinkManager.createIssueLink(sourceIssue.getId(), destinationIssue.getId(), linkType.getId(), null, result.getUser());
                } else {
                    this.issueLinkManager.createIssueLink(destinationIssue.getId(), sourceIssue.getId(), linkType.getId(), null, result.getUser());
                }
                this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, result.getUser(), String.valueOf(linkType.getId()), result.getLinkName());
            }
            catch (CreateException createE) {
                throw new RuntimeException(createE);
            }
        }
        return this.getIssueLinks(user, result.getIssue());
    }

    public IssueLinkService.DeleteIssueLinkValidationResult validateDelete(User user, Issue issue, com.atlassian.jira.issue.issuelink.IssueLink issueLink) {
        ErrorCollection errors = this.validateIssuePermission(user, issue, 21, "admin.errors.issues.no.permission.to.delete.links");
        this.validateLinkingEnabled(user, errors);
        if (issueLink == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("admin.errors.issues.cannot.find.link"), ErrorCollection.Reason.NOT_FOUND);
        }
        return new IssueLinkService.DeleteIssueLinkValidationResult(errors, errors.hasAnyErrors() ? null : issueLink, user);
    }

    public void delete(IssueLinkService.DeleteIssueLinkValidationResult validationResult) {
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        if (!validationResult.isValid()) {
            throw new IllegalStateException("You cannot delete an issue link with an invalid validation result.");
        }
        com.atlassian.jira.issue.issuelink.IssueLink issueLink = validationResult.getIssueLink();
        Long sourceId = issueLink.getSourceIssue().getId();
        Long destinationId = issueLink.getDestinationIssue().getId();
        Long issueLinkTypeId = issueLink.getIssueLinkType().getId();
        try {
            this.issueLinkManager.removeIssueLink(this.issueLinkManager.getIssueLink(sourceId, destinationId, issueLinkTypeId), validationResult.getUser());
        }
        catch (RemoveException e) {
            throw new RuntimeException("Issue link deletion failed", e);
        }
    }

    private ErrorCollection validateIssuePermission(User user, Issue issue, int permissionsId) {
        return this.validateIssuePermission(user, issue, permissionsId, "issuelinking.service.error.issue.no.permission");
    }

    private ErrorCollection validateIssuePermission(User user, Issue issue, int permissionsId, String errorMsgKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issue == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.issue.doesnt.exist"));
            return errors;
        }
        if (!this.permissionManager.hasPermission(permissionsId, issue, user)) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText(errorMsgKey, issue.getKey()));
        }
        return errors;
    }

    private void validateLinkingEnabled(User user, ErrorCollection errors) {
        I18nHelper i18n = this.beanFactory.getInstance(user);
        if (!this.issueLinkManager.isLinkingEnabled()) {
            errors.addErrorMessage(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private void validateLinkInput(User user, ErrorCollection errors, Issue issue, com.atlassian.jira.issue.issuelink.IssueLinkType linkType, Collection<String> linkKeys, boolean excludeSystemLinks) {
        if (excludeSystemLinks && linkType.isSystemLinkType()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.type", linkType.getName()));
        }
        if (linkKeys == null || linkKeys.isEmpty()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.must.provide.issue.links"));
        } else {
            for (String linkKey : linkKeys) {
                MutableIssue linkedIssue;
                if (linkKey.equalsIgnoreCase(issue.getKey())) {
                    errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.self.reference", linkKey));
                }
                if ((linkedIssue = this.issueManager.getIssueObject(linkKey)) != null) continue;
                errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.linked.issue.doesnt.exist", linkKey));
            }
        }
    }

    private com.atlassian.jira.issue.issuelink.IssueLinkType resolveIssueLinkTypeById(Long issueLinkTypeId) {
        IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLinkTypeId);
        if (issueLinkType == null) {
            return null;
        }
        return this.transformIssueLinkType(issueLinkType);
    }

    private IssueLinkService.IssueLinkResult makeIssueLinkResult(ErrorCollection errorCollection, final Issue issue, Collection<IssueLinkType> issueLinkTypes, final Collection<com.atlassian.jira.issue.issuelink.IssueLink> allIssues, final Map<String, List<com.atlassian.jira.issue.issuelink.IssueLink>> outwardIssues, final Map<String, List<com.atlassian.jira.issue.issuelink.IssueLink>> inwardIssues) {
        final HashSet<com.atlassian.jira.issue.issuelink.IssueLinkType> transformedTypes = new HashSet<com.atlassian.jira.issue.issuelink.IssueLinkType>(this.transformIssueLinkType(issueLinkTypes));
        return new IssueLinkService.IssueLinkResult(errorCollection, transformedTypes, new IssueLinks(){

            public Issue getIssue() {
                return issue;
            }

            public Set<com.atlassian.jira.issue.issuelink.IssueLinkType> getLinkTypes() {
                return transformedTypes;
            }

            public Collection<com.atlassian.jira.issue.issuelink.IssueLink> getOutwardIssues(String linkName) {
                return (Collection)outwardIssues.get(linkName);
            }

            public Collection<com.atlassian.jira.issue.issuelink.IssueLink> getInwardIssues(String linkName) {
                return (Collection)inwardIssues.get(linkName);
            }

            public Collection<com.atlassian.jira.issue.issuelink.IssueLink> getAllIssues() {
                return allIssues;
            }
        });
    }

    private com.atlassian.jira.issue.issuelink.IssueLinkType matchToIssueLinkType(String linkName) {
        Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypes();
        for (IssueLinkType linkType : linkTypes) {
            if (!linkName.equals(linkType.getOutward()) && !linkName.equals(linkType.getInward())) continue;
            return this.transformIssueLinkType(linkType);
        }
        return null;
    }

    private List<com.atlassian.jira.issue.issuelink.IssueLink> transformListToIssueLink(final Issue sourceIssue, List<Issue> destinationIssues, final IssueLinkType linkType) {
        ArrayList issueLinks = Lists.newArrayList();
        for (final Issue destinationIssue : destinationIssues) {
            issueLinks.add(new com.atlassian.jira.issue.issuelink.IssueLink(){

                public Issue getSourceIssue() {
                    return sourceIssue;
                }

                public Issue getDestinationIssue() {
                    return destinationIssue;
                }

                public com.atlassian.jira.issue.issuelink.IssueLinkType getIssueLinkType() {
                    return DefaultIssueLinkService.this.transformIssueLinkType(linkType);
                }
            });
        }
        return issueLinks;
    }

    private Collection<com.atlassian.jira.issue.issuelink.IssueLinkType> transformIssueLinkType(Collection<IssueLinkType> issueLinkTypes) {
        ArrayList<com.atlassian.jira.issue.issuelink.IssueLinkType> transformedList = new ArrayList<com.atlassian.jira.issue.issuelink.IssueLinkType>(issueLinkTypes.size());
        for (IssueLinkType rawIssueLinkType : issueLinkTypes) {
            transformedList.add(this.transformIssueLinkType(rawIssueLinkType));
        }
        return Collections.unmodifiableCollection(transformedList);
    }

    private com.atlassian.jira.issue.issuelink.IssueLinkType transformIssueLinkType(final IssueLinkType rawIssueLinkType) {
        return new com.atlassian.jira.issue.issuelink.IssueLinkType(){

            public Long getId() {
                return rawIssueLinkType.getId();
            }

            public String getName() {
                return rawIssueLinkType.getName();
            }

            public String getOutward() {
                return rawIssueLinkType.getOutward();
            }

            public String getInward() {
                return rawIssueLinkType.getInward();
            }

            public String getStyle() {
                return rawIssueLinkType.getStyle();
            }

            public boolean isSubTaskLinkType() {
                return rawIssueLinkType.isSubTaskLinkType();
            }

            public boolean isSystemLinkType() {
                return rawIssueLinkType.isSystemLinkType();
            }
        };
    }
}

