/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ajsmeta;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.ajsmeta.DarkFeaturesMeta;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

@Internal
public final class HtmlMetadataManager {
    private final JiraWebResourceManager webResourceManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FeatureManager featureManager;

    public HtmlMetadataManager(JiraWebResourceManager webResourceManager, BuildUtilsInfo buildUtilsInfo, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, KeyboardShortcutManager keyboardShortcutManager, VelocityRequestContextFactory velocityRequestContextFactory, FeatureManager featureManager) {
        this.webResourceManager = webResourceManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.featureManager = featureManager;
    }

    public void includeMetadata(Writer writer) throws IOException {
        if (Boolean.getBoolean("atlassian.disable.issue.collector")) {
            this.webResourceManager.putMetadata("disable-issue-collector", "true");
        }
        this.webResourceManager.putMetadata("context-path", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
        this.webResourceManager.putMetadata("version-number", this.buildUtilsInfo.getVersion());
        this.webResourceManager.putMetadata("build-number", this.buildUtilsInfo.getCurrentBuildNumber());
        this.webResourceManager.putMetadata("remote-user", this.authenticationContext.getLoggedInUser() != null ? this.authenticationContext.getLoggedInUser().getName() : "");
        this.webResourceManager.putMetadata("remote-user-fullname", this.authenticationContext.getLoggedInUser() != null ? this.authenticationContext.getLoggedInUser().getDisplayName() : "");
        this.webResourceManager.putMetadata("user-locale", this.authenticationContext.getLocale().toString());
        this.webResourceManager.putMetadata("app-title", this.getAppTitle());
        this.webResourceManager.putMetadata("keyboard-shortcuts-enabled", Boolean.toString(this.keyboardShortcutManager.isKeyboardShortcutsEnabled()));
        this.webResourceManager.putMetadata("enabled-dark-features", new DarkFeaturesMeta(this.featureManager).getContent());
        this.writeTo(writer);
    }

    private void writeTo(Writer writer) throws IOException {
        Map metadata = this.webResourceManager.getMetadata();
        for (Map.Entry metaDataEntry : metadata.entrySet()) {
            writer.write("<meta name=\"ajs-");
            writer.write(TextUtils.htmlEncode((String)((String)metaDataEntry.getKey())));
            writer.write("\" content=\"");
            writer.write(TextUtils.htmlEncode((String)((String)metaDataEntry.getValue())));
            writer.write("\">\n");
        }
    }

    private String getAppTitle() {
        return this.applicationProperties.getDefaultBackedString("jira.title");
    }
}

