/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflowComparator;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractJiraWorkflow
implements JiraWorkflow {
    private static final Logger log = Logger.getLogger(AbstractJiraWorkflow.class);
    WorkflowDescriptor descriptor;
    protected final WorkflowManager workflowManager;
    private final MultiMap fieldScreens;

    protected AbstractJiraWorkflow(WorkflowManager workflowManager, WorkflowDescriptor workflowDescriptor) {
        this.workflowManager = workflowManager;
        this.descriptor = workflowDescriptor;
        this.fieldScreens = new MultiHashMap();
        this.reset();
    }

    public abstract String getName();

    public String getDescription() {
        return (String)this.descriptor.getMetaAttributes().get("jira.description");
    }

    public WorkflowDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Collection getAllActions() {
        return this.getAllActionsMap().values();
    }

    public int getNextActionId() {
        int offset = 0;
        SortedMap allActionsMap = this.getAllActionsMap();
        if (!allActionsMap.isEmpty()) {
            offset = (Integer)allActionsMap.lastKey();
        }
        return offset + 10;
    }

    private SortedMap getAllActionsMap() {
        TreeMap<Integer, ActionDescriptor> actions = new TreeMap<Integer, ActionDescriptor>();
        this.addActionsToMap(actions, this.descriptor.getInitialActions());
        this.addActionsToMap(actions, this.descriptor.getGlobalActions());
        actions.putAll(this.descriptor.getCommonActions());
        List steps = this.descriptor.getSteps();
        for (StepDescriptor stepDescriptor : steps) {
            for (ActionDescriptor actionDescriptor : stepDescriptor.getActions()) {
                if (actions.containsKey(new Integer(actionDescriptor.getId()))) continue;
                actions.put(new Integer(actionDescriptor.getId()), actionDescriptor);
            }
        }
        return actions;
    }

    private void addActionsToMap(SortedMap actions, Collection initialActions) {
        for (ActionDescriptor actionDescriptor : initialActions) {
            actions.put(new Integer(actionDescriptor.getId()), actionDescriptor);
        }
    }

    public Collection getActionsWithResult(StepDescriptor stepDescriptor) {
        Collection actions = this.getAllActions();
        Iterator iterator = actions.iterator();
        block0: while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)iterator.next();
            for (ResultDescriptor resultDescriptor : actionDescriptor.getConditionalResults()) {
                if (resultDescriptor.getStep() != stepDescriptor.getId()) continue;
                continue block0;
            }
            if (actionDescriptor.getUnconditionalResult().getStep() == stepDescriptor.getId()) continue;
            iterator.remove();
        }
        return actions;
    }

    public Collection getStepsWithAction(StepDescriptor stepDescriptor) {
        Collection actions = this.getAllActions();
        Iterator iterator = actions.iterator();
        block0: while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)iterator.next();
            for (ResultDescriptor resultDescriptor : actionDescriptor.getConditionalResults()) {
                if (resultDescriptor.getStep() != stepDescriptor.getId()) continue;
                continue block0;
            }
            if (actionDescriptor.getUnconditionalResult().getStep() == stepDescriptor.getId()) continue;
            iterator.remove();
        }
        return actions;
    }

    public boolean removeStep(StepDescriptor stepDescriptor) {
        if (!this.getActionsWithResult(stepDescriptor).isEmpty()) {
            throw new IllegalArgumentException("Cannot remove step - it is a destination step of at least one transition.");
        }
        return this.descriptor.getSteps().remove(stepDescriptor);
    }

    public StepDescriptor getLinkedStep(GenericValue status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return this.getLinkedStep(status.getString("id"));
    }

    public StepDescriptor getLinkedStep(Status status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return this.getLinkedStep(status.getId());
    }

    private StepDescriptor getLinkedStep(String statusId) {
        if (statusId == null) {
            throw new IllegalArgumentException();
        }
        for (StepDescriptor stepDescriptor : this.descriptor.getSteps()) {
            if (!statusId.equals(stepDescriptor.getMetaAttributes().get("jira.status.id"))) continue;
            return stepDescriptor;
        }
        return null;
    }

    public GenericValue getLinkedStatus(StepDescriptor stepDescriptor) {
        String statusId;
        if (stepDescriptor == null) {
            throw new IllegalArgumentException("Step cannot be null.");
        }
        if (stepDescriptor.getMetaAttributes() != null && stepDescriptor.getMetaAttributes().containsKey("jira.status.id") && (statusId = (String)stepDescriptor.getMetaAttributes().get("jira.status.id")) != null) {
            return ManagerFactory.getConstantsManager().getStatus(statusId);
        }
        throw new IllegalStateException("Step with id '" + stepDescriptor.getId() + "' does not have a valid linked status.");
    }

    public Status getLinkedStatusObject(StepDescriptor stepDescriptor) {
        String statusId;
        if (stepDescriptor == null) {
            throw new IllegalArgumentException("Step cannot be null.");
        }
        if (stepDescriptor.getMetaAttributes() != null && stepDescriptor.getMetaAttributes().containsKey("jira.status.id") && (statusId = (String)stepDescriptor.getMetaAttributes().get("jira.status.id")) != null) {
            return ManagerFactory.getConstantsManager().getStatusObject(statusId);
        }
        throw new IllegalStateException("Step with id '" + stepDescriptor.getId() + "' does not have a valid linked status.");
    }

    public List getLinkedStatuses() {
        ArrayList<GenericValue> statuses = new ArrayList<GenericValue>();
        for (StepDescriptor stepDescriptor : this.descriptor.getSteps()) {
            statuses.add(this.getLinkedStatus(stepDescriptor));
        }
        return statuses;
    }

    public List getLinkedStatusObjects() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (StepDescriptor stepDescriptor : this.descriptor.getSteps()) {
            statuses.add(this.getLinkedStatusObject(stepDescriptor));
        }
        return statuses;
    }

    public Collection getStepsForTransition(ActionDescriptor actionDescriptor) {
        if (this.isInitialAction(actionDescriptor)) {
            return Collections.EMPTY_LIST;
        }
        if (this.isGlobalAction(actionDescriptor)) {
            return this.getDescriptor().getSteps();
        }
        if (this.isCommonAction(actionDescriptor)) {
            LinkedList<StepDescriptor> steps = new LinkedList<StepDescriptor>();
            for (StepDescriptor stepDescriptor : this.descriptor.getSteps()) {
                Iterator iterator1 = stepDescriptor.getCommonActions().iterator();
                while (iterator1.hasNext()) {
                    if (((Integer)iterator1.next()).intValue() != actionDescriptor.getId()) continue;
                    steps.add(stepDescriptor);
                }
            }
            return steps;
        }
        LinkedList<StepDescriptor> steps = new LinkedList<StepDescriptor>();
        for (StepDescriptor stepDescriptor : this.descriptor.getSteps()) {
            for (ActionDescriptor ad : stepDescriptor.getActions()) {
                if (ad.getId() != actionDescriptor.getId()) continue;
                steps.add(stepDescriptor);
                return steps;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor actionDescriptor) {
        List conditionalResults;
        ArrayList<FunctionDescriptor> allPostFunctions = new ArrayList<FunctionDescriptor>();
        if (actionDescriptor.getUnconditionalResult() != null && actionDescriptor.getUnconditionalResult().getPostFunctions() != null) {
            allPostFunctions.addAll(actionDescriptor.getUnconditionalResult().getPostFunctions());
        }
        if ((conditionalResults = actionDescriptor.getConditionalResults()) != null) {
            for (ResultDescriptor resultDescriptor : conditionalResults) {
                allPostFunctions.addAll(resultDescriptor.getPostFunctions());
            }
        }
        if (actionDescriptor.getPostFunctions() != null) {
            allPostFunctions.addAll(actionDescriptor.getPostFunctions());
        }
        return allPostFunctions;
    }

    public boolean isActive() throws WorkflowException {
        return this.workflowManager.isActive((JiraWorkflow)this);
    }

    public boolean isSystemWorkflow() throws WorkflowException {
        return this.workflowManager.isSystemWorkflow((JiraWorkflow)this);
    }

    public boolean isEditable() throws WorkflowException {
        return !this.isSystemWorkflow() && !this.isActive();
    }

    public boolean isDefault() {
        return "jira".equals(this.getName());
    }

    public boolean isInitialAction(ActionDescriptor actionDescriptor) {
        return this.getDescriptor().getInitialActions().contains(actionDescriptor);
    }

    public boolean isCommonAction(ActionDescriptor actionDescriptor) {
        return actionDescriptor.isCommon();
    }

    public boolean isGlobalAction(ActionDescriptor actionDescriptor) {
        return this.getDescriptor().getGlobalActions().contains(actionDescriptor);
    }

    public boolean isOrdinaryAction(ActionDescriptor actionDescriptor) {
        return !this.isInitialAction(actionDescriptor) && !this.isCommonAction(actionDescriptor) && !this.isGlobalAction(actionDescriptor);
    }

    public String getActionType(ActionDescriptor actionDescriptor) {
        if (actionDescriptor == null) {
            throw new IllegalArgumentException("ActionDescriptor cannot be null.");
        }
        if (this.isInitialAction(actionDescriptor)) {
            return "initial";
        }
        if (this.isGlobalAction(actionDescriptor)) {
            return "global";
        }
        if (this.isCommonAction(actionDescriptor)) {
            return "common";
        }
        if (this.isOrdinaryAction(actionDescriptor)) {
            return "ordinary";
        }
        throw new IllegalArgumentException("The action with id '" + actionDescriptor.getId() + "' is of unknown type.");
    }

    public void reset() {
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        for (ActionDescriptor actionDescriptor : this.getAllActions()) {
            this.fieldScreens.put((Object)workflowActionsBean.getFieldScreenForView(actionDescriptor), (Object)actionDescriptor);
        }
    }

    public Collection getActionsForScreen(FieldScreen fieldScreen) {
        if (this.fieldScreens.containsKey((Object)fieldScreen)) {
            return (Collection)this.fieldScreens.get((Object)fieldScreen);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractJiraWorkflow)) {
            return false;
        }
        AbstractJiraWorkflow abstractJiraWorkflow = (AbstractJiraWorkflow)o;
        return this.getName().equals(abstractJiraWorkflow.getName());
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public int compareTo(JiraWorkflow o) {
        return JiraWorkflowComparator.COMPARATOR.compare(this, o);
    }

    public String getUpdateAuthorName() {
        String updateAuthor = null;
        Map metaAttributes = this.descriptor.getMetaAttributes();
        if (metaAttributes != null) {
            updateAuthor = (String)metaAttributes.get("jira.update.author.name");
        }
        return updateAuthor;
    }

    public Date getUpdatedDate() {
        String updateDateStr;
        Map metaAttributes = this.descriptor.getMetaAttributes();
        if (metaAttributes != null && (updateDateStr = (String)metaAttributes.get("jira.updated.date")) != null) {
            try {
                long timeInMillis = Long.parseLong(updateDateStr);
                return new Date(timeInMillis);
            }
            catch (NumberFormatException e) {
                log.error((Object)("The workflow '" + this.getName() + "' is storing a invalid updated date string '" + updateDateStr + "'."), (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasDraftWorkflow() {
        return this.workflowManager.getDraftWorkflow(this.getName()) != null;
    }

    public String getMode() {
        if (this.isDraftWorkflow()) {
            return "draft";
        }
        return "live";
    }
}

