/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HostileAttachmentsHelper
implements Serializable {
    private static final Logger log = Logger.getLogger(HostileAttachmentsHelper.class);
    public static final String DELIMITER_REGEX = "\\s+";
    static final String KEY_EXECUTABLE_CONTENT_TYPES = "executable.mime.types";
    static final String KEY_EXECUTABLE_FILE_EXTENSIONS = "executable.file.extensions";
    private static final String CONFIG_FILE = "hostile-attachments-config.properties";
    private static final String[] DEFAULT_EXECUTABLE_FILE_EXTENSIONS = new String[]{".htm", ".html", ".xhtml", ".xml", ".svg", ".swf", ".cab", ".flv", ".f4v", ".f4p", ".f4a", ".f4b"};
    private static final String[] DEFAULT_EXECUTABLE_CONTENT_TYPES = new String[]{"text/html", "text/html-sandboxed", "text/xhtml", "application/xhtml+xml", "text/xml", "application/xml", "text/xml-external-parsed-entity", "application/xml-external-parsed-entity", "application/xml-dtd", "application/x-shockwave-flash", "image/svg+xml", "image/svg-xml", "application/futuresplash"};
    private String[] executableFileExtensions = DEFAULT_EXECUTABLE_FILE_EXTENSIONS;
    private String[] executableContentTypes = DEFAULT_EXECUTABLE_CONTENT_TYPES;

    public HostileAttachmentsHelper() {
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        Properties config = new Properties();
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)CONFIG_FILE, this.getClass());
        if (in != null) {
            try {
                config.load(in);
            }
            catch (IOException e) {
                log.warn((Object)"Unable to load config from 'hostile-attachments-config.properties' falling back to defaults ");
                return;
            }
            finally {
                IOUtil.shutdownStream(in);
            }
            this.parseConfiguration(config);
        } else {
            log.warn((Object)"Unable to load config from 'hostile-attachments-config.properties' falling back to defaults ");
        }
    }

    void parseConfiguration(Properties config) {
        String extensions = config.getProperty(KEY_EXECUTABLE_FILE_EXTENSIONS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configured executable file extensions: '" + extensions + "'"));
        }
        if (!StringUtils.isBlank((String)extensions)) {
            this.executableFileExtensions = extensions.trim().split(DELIMITER_REGEX);
        }
        String contentTypes = config.getProperty(KEY_EXECUTABLE_CONTENT_TYPES);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executable content types: '" + contentTypes + "'"));
        }
        if (!StringUtils.isBlank((String)contentTypes)) {
            this.executableContentTypes = contentTypes.trim().split(DELIMITER_REGEX);
        }
    }

    public boolean isExecutableFileExtension(String name) {
        boolean isExecutableFileExtension = false;
        if (!StringUtils.isBlank((String)name)) {
            for (String executableFileExtension : this.executableFileExtensions) {
                if (!this.endsWithIgnoreCase(name, executableFileExtension)) continue;
                isExecutableFileExtension = true;
                break;
            }
        }
        return isExecutableFileExtension;
    }

    public boolean isExecutableContentType(String contentType) {
        boolean isExecutableContentType = false;
        if (!StringUtils.isBlank((String)contentType)) {
            for (String executableContentType : this.executableContentTypes) {
                if (!executableContentType.equalsIgnoreCase(contentType)) continue;
                isExecutableContentType = true;
                break;
            }
        }
        return isExecutableContentType;
    }

    boolean endsWithIgnoreCase(String stringToSearch, String candidateSuffix) {
        int csLen;
        int stsLen = stringToSearch.length();
        return stsLen >= (csLen = candidateSuffix.length()) && stringToSearch.substring(stsLen - csLen, stsLen).equalsIgnoreCase(candidateSuffix);
    }

    String[] getExecutableFileExtensions() {
        return this.executableFileExtensions;
    }

    String[] getExecutableContentTypes() {
        return this.executableContentTypes;
    }
}

