/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.IssuePager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWriter;
import com.atlassian.jira.web.component.subtask.ColumnLayoutItemFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueTableWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class);
    private final ColumnLayoutItemFactory columnLayoutItemFactory = ComponentManager.getComponentInstanceOfType(ColumnLayoutItemFactory.class);
    private static final String ISSUETABLE_HEADER = "templates/jira/issue/table/issuetable-header.vm";
    private static final String ISSUETABLE_FOOTER = "templates/jira/issue/table/issuetable-footer.vm";
    private static final String ISSUETABLE_SINGLE_ISSUE = "templates/jira/issue/table/issuetable-issue.vm";
    private static final String CARROT_HIDDEN = "class=\"hide-carrot\"";

    public IssueTableWebComponent() {
        super((VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class), (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class));
    }

    public String getHtml(IssueTableLayoutBean layout, List<Issue> issues, IssuePager pager) {
        return this.getHtml(layout, issues, pager, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(IssueTableLayoutBean layout, List<Issue> issues, IssuePager pager, Long selectedIssueId) {
        try {
            UtilTimerStack.push((String)"IssueTableHtml");
            StringWriter writer = new StringWriter();
            try {
                ColumnLayoutItem actionColumn = layout.isShowActionColumn() && this.authenticationContext.getLoggedInUser() != null ? this.columnLayoutItemFactory.getActionsAndOperationsColumn() : null;
                IssueTableWriter issueTableWriter = this.getHtmlIssueWriter(writer, layout, pager, actionColumn, selectedIssueId);
                for (Issue issue : issues) {
                    issueTableWriter.write(issue);
                }
                issueTableWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String string = writer.toString();
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"IssueTableHtml");
        }
    }

    public IssueTableWriter getHtmlIssueWriter(Writer writer, IssueTableLayoutBean layout, IssuePager pager, ColumnLayoutItem actionColumn) {
        return this.getHtmlIssueWriter(writer, layout, pager, actionColumn, null);
    }

    public IssueTableWriter getHtmlIssueWriter(final Writer writer, IssueTableLayoutBean layout, IssuePager pager, ColumnLayoutItem actionColumn, Long selectedIssueId) {
        String carrothiddenString = "";
        boolean keyboadShortcutsEnabled = true;
        if (this.authenticationContext.getLoggedInUser() != null) {
            Preferences userPrefs = ComponentAccessor.getUserPreferencesManager().getPreferences(this.authenticationContext.getLoggedInUser());
            boolean bl = keyboadShortcutsEnabled = !userPrefs.getBoolean("user.keyboard.shortcuts.disabled");
        }
        if (!keyboadShortcutsEnabled) {
            carrothiddenString = CARROT_HIDDEN;
        }
        final Map<String, Object> params = this.getDefaultParams(MapBuilder.newBuilder().add((Object)"layout", (Object)layout).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).add((Object)"pager", (Object)pager).add((Object)"columnTotals", null).add((Object)"actionColumn", (Object)actionColumn).add((Object)"selectedIssueId", (Object)selectedIssueId).add((Object)"carrothidden", (Object)carrothiddenString).toMap());
        return new IssueTableWriter(){
            int issueCount = 0;

            @Override
            public void write(Issue issue) throws IOException {
                ++this.issueCount;
                if (this.issueCount == 1) {
                    writer.write(IssueTableWebComponent.this.getHtml(IssueTableWebComponent.ISSUETABLE_HEADER, params));
                }
                HashMap<String, Object> issueParams = new HashMap<String, Object>();
                issueParams.put("issue", issue);
                issueParams.put("issueCount", this.issueCount);
                writer.write(IssueTableWebComponent.this.getHtml(IssueTableWebComponent.ISSUETABLE_SINGLE_ISSUE, CompositeMap.of(issueParams, (Map)params)));
            }

            @Override
            public void close() throws IOException {
                if (this.issueCount > 0) {
                    writer.write(IssueTableWebComponent.this.getHtml(IssueTableWebComponent.ISSUETABLE_FOOTER, params));
                }
            }
        };
    }

    private Map<String, Object> getDefaultParams(Map<String, Object> startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }
}

