/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.web.bean.WorkflowDescriptorInfo;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkflowDescriptorFormatBean {
    private static final Logger log = Logger.getLogger(WorkflowDescriptorFormatBean.class);
    private Collection descriptorCollection;
    private String deleteAction;
    private String editAction;
    private boolean delete;
    private boolean orderable;
    private boolean edit;
    private final PluginAccessor pluginAccessor;
    private String pluginType;
    private String operatorTextKey;

    public WorkflowDescriptorFormatBean(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.descriptorCollection = Collections.EMPTY_LIST;
        this.delete = false;
        this.edit = false;
    }

    public WorkflowDescriptorFormatBean() {
        this(ComponentAccessor.getPluginAccessor());
    }

    public WorkflowDescriptorInfo formatDescriptor(AbstractDescriptor descriptor) {
        Map args;
        String type;
        if (descriptor instanceof FunctionDescriptor) {
            type = ((FunctionDescriptor)descriptor).getType();
            args = ((FunctionDescriptor)descriptor).getArgs();
        } else if (descriptor instanceof ConditionDescriptor) {
            type = ((ConditionDescriptor)descriptor).getType();
            args = ((ConditionDescriptor)descriptor).getArgs();
        } else if (descriptor instanceof ValidatorDescriptor) {
            type = ((ValidatorDescriptor)descriptor).getType();
            args = ((ValidatorDescriptor)descriptor).getArgs();
        } else {
            throw new IllegalArgumentException("Invalid descriptor type");
        }
        if ("class".equalsIgnoreCase(type) && args.containsKey("class.name")) {
            String className = (String)args.get("class.name");
            try {
                AbstractWorkflowModuleDescriptor abstractWorkflowModuleDescriptor = this.getWorkflowModuleDescriptor(className, this.pluginType);
                if (abstractWorkflowModuleDescriptor != null) {
                    String description = abstractWorkflowModuleDescriptor.getHtml("view", descriptor);
                    return new WorkflowDescriptorInfo(description, this.orderable && abstractWorkflowModuleDescriptor.isOrderable(), this.delete && abstractWorkflowModuleDescriptor.isDeletable(), this.edit && abstractWorkflowModuleDescriptor.isEditable());
                }
                return new WorkflowDescriptorInfo(null, this.orderable, this.delete, false);
            }
            catch (PluginParseException e) {
                String message = "Cannot find module descriptors.";
                log.error((Object)"Cannot find module descriptors.", (Throwable)e);
                throw new RuntimeException("Cannot find module descriptors.", e);
            }
        }
        return new WorkflowDescriptorInfo("Type: " + type + " with arguments " + args, this.orderable, this.delete, false);
    }

    protected AbstractWorkflowModuleDescriptor getWorkflowModuleDescriptor(String className, String pluginType) throws PluginParseException {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByType(pluginType);
        for (AbstractWorkflowModuleDescriptor abstractWorkflowModuleDescriptor : moduleDescriptors) {
            if (!abstractWorkflowModuleDescriptor.getImplementationClass().getName().equals(className)) continue;
            return abstractWorkflowModuleDescriptor;
        }
        return null;
    }

    public Collection getDescriptorCollection() {
        return this.descriptorCollection;
    }

    public void setDescriptorCollection(Collection descriptorCollection) {
        this.descriptorCollection = descriptorCollection;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public void setOrderable(boolean orderable) {
        this.orderable = orderable;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(String deleteAction) {
        this.deleteAction = deleteAction;
    }

    public String getEditAction() {
        return this.editAction;
    }

    public void setEditAction(String editAction) {
        this.editAction = editAction;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public boolean isHasRelevantArgs(Map args) {
        return args != null && !args.isEmpty() && (args.size() != 1 || !args.containsKey("class.name"));
    }

    public String getOperatorTextKey() {
        return this.operatorTextKey;
    }

    public void setOperatorTextKey(String operatorTextKey) {
        this.operatorTextKey = operatorTextKey;
    }

    public String getParentPrefix() {
        return "";
    }

    public void setParentPrefix(String parentPrefix) {
    }

    public boolean isAllowNested() {
        return false;
    }

    public boolean isHighlighted(int count, String current) {
        return (this.getPluginType() + this.getParentPrefix() + count).equals(current);
    }

    public boolean isMultipleDescriptors() {
        return this.descriptorCollection != null && this.descriptorCollection.size() > 1;
    }

    public boolean isSingleDescriptor() {
        return this.descriptorCollection != null && this.descriptorCollection.size() == 1;
    }
}

