/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.plugin.language.TranslationTransform;
import com.atlassian.jira.plugin.util.InvolvedPluginsTracker;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.log4j.Logger;

@Immutable
@Internal
@VisibleForTesting
public class BackingI18n
implements I18nHelper {
    private static final Logger log = Logger.getLogger(I18nHelper.class);
    private static final ResourceBundle.Control NO_FALLBACK_CONTROL = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final char START_HIGHLIGHT_CHAR = '\ufeff';
    private static final char MIDDLE_HIGHLIGHT_CHAR = '\u26a1';
    private static final char END_HIGHLIGHT_CHAR = '\u2060';
    private static final int INITIAL_FLATTENED_MAP_SIZE = 8192;
    private static final String PLUGIN_RESOURCE_TYPE_I18N = "i18n";
    private static final ResourceBundleLocaleSorter RESOURCE_BUNDLE_LOCALE_SORTER = new ResourceBundleLocaleSorter();
    private final Locale locale;
    private final Map<String, Set<String>> prefixKeysCache = new MapMaker().makeComputingMap((Function)new PrefixFunction());
    private final Map<String, String> translationMap;
    private final I18nTranslationMode i18nTranslationMode;
    private final InvolvedPluginsTracker involvedPluginsTracker;
    private final List<TranslationTransform> translationTransforms;

    public BackingI18n(Locale locale, I18nTranslationMode i18nTranslationMode, InvolvedPluginsTracker involvedPluginsTracker, List<TranslationTransform> translationTransforms) {
        this.involvedPluginsTracker = (InvolvedPluginsTracker)Assertions.notNull((String)"pluginsInvolvedTracker", (Object)involvedPluginsTracker);
        this.i18nTranslationMode = (I18nTranslationMode)Assertions.notNull((String)"i18nTranslationMode", (Object)i18nTranslationMode);
        this.locale = (Locale)Assertions.notNull((String)"locale", (Object)locale);
        this.translationMap = this.loadV1AndV2LanguagePacksAndPluginsBundles(locale);
        this.translationTransforms = (List)Assertions.notNull((String)"translationTransforms", translationTransforms);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getDefaultResourceBundle() {
        return DefaultResourceBundle.getDefaultResourceBundle(this.locale);
    }

    protected PluginAccessor getPluginAccessor() {
        return ComponentAccessor.getPluginAccessor();
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return this.prefixKeysCache.get(prefix);
    }

    public String getUnescapedText(String key) {
        String value = this.getTranslation(key = this.cleanKey(key));
        return value != null ? value : key;
    }

    public String getUntransformedRawText(String key) {
        String rawMessage = this.translationMap.get(key = this.cleanKey(key));
        if (rawMessage != null) {
            return rawMessage;
        }
        return key;
    }

    public boolean isKeyDefined(String key) {
        return this.translationMap.containsKey(this.cleanKey(key));
    }

    public String getText(String key) {
        return this.formatI18nMsg(key, new Object[0]);
    }

    public String getText(String key, String value1) {
        return this.formatI18nMsg(key, value1);
    }

    public String getText(String key, String value1, String value2) {
        return this.formatI18nMsg(key, value1, value2);
    }

    public String getText(String key, String value1, String value2, String value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public String getText(String key, Object parameters) {
        Object[] substitutionParameters = parameters instanceof Object[] ? (Object[])parameters : (parameters instanceof Iterable ? Iterables.toArray((Iterable)((Iterable)parameters), Object.class) : (parameters == null ? EMPTY_ARRAY : new Object[]{parameters}));
        return this.formatI18nMsg(key, substitutionParameters);
    }

    private String cleanKey(String key) {
        return key != null && key.length() >= 2 && key.charAt(0) == '\'' && key.charAt(key.length() - 1) == '\'' ? key.substring(1, key.length() - 1) : key;
    }

    private String formatI18nMsg(String key, Object ... substitutionParameters) {
        MessageFormat mf;
        String rawMessage = this.getTranslation(key = this.cleanKey(key));
        if (rawMessage == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find i18n key: " + key));
            }
            return this.hilightMsg(key, key, key);
        }
        try {
            mf = new MessageFormat(rawMessage, this.locale);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Error rendering '" + rawMessage + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        String formattedMsg = mf.format(substitutionParameters == null ? EMPTY_ARRAY : substitutionParameters);
        return this.hilightMsg(key, rawMessage, formattedMsg);
    }

    private String getTranslation(String key) {
        String rawMessage = this.translationMap.get(key);
        if (rawMessage != null) {
            rawMessage = this.processTranslationTransforms(key, rawMessage);
        }
        return rawMessage;
    }

    private String processTranslationTransforms(String key, String rawMessage) {
        String result = rawMessage;
        for (TranslationTransform translationTransform : this.translationTransforms) {
            result = translationTransform.apply(this.locale, key, result);
        }
        return result;
    }

    private String hilightMsg(String key, String rawMessage, String formattedMsg) {
        if (this.i18nTranslationMode.isTranslationMode()) {
            if (formattedMsg.equals(rawMessage)) {
                return String.format("%c%s%c%s%c%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), Character.valueOf('\u2060'));
            }
            return String.format("%c%s%c%s%c%s%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), rawMessage, Character.valueOf('\u2060'));
        }
        return formattedMsg;
    }

    private Map<String, String> loadV1AndV2LanguagePacksAndPluginsBundles(Locale locale) {
        PluginAccessor pluginAccessor;
        List<ResourceBundle> v1ClassPathJiraWebActionSupportBundles = Arrays.asList(this.getDefaultResourceBundle());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loaded v1 support bundles; targetLocale=" + locale + "; resource locale=" + v1ClassPathJiraWebActionSupportBundles.get(0).getLocale()));
        }
        if ((pluginAccessor = this.getPluginAccessor()) == null) {
            return this.flattenResourceBundlesToMap(v1ClassPathJiraWebActionSupportBundles);
        }
        Iterable<ResourceBundle> v2LanguagePackSourceBundles = this.loadV2LanguagePackBundles(locale, pluginAccessor);
        Iterable<ResourceBundle> pluginSourcedBundles = this.loadPluginSourcedBundles(locale, pluginAccessor);
        return this.flattenResourceBundlesToMap(Iterables.concat(pluginSourcedBundles, v1ClassPathJiraWebActionSupportBundles, v2LanguagePackSourceBundles));
    }

    static boolean providedLocaleMatches(Locale providedLocale, Locale targetLocale) {
        if (providedLocale.getLanguage().length() == 0) {
            return true;
        }
        if (!providedLocale.getLanguage().equals(targetLocale.getLanguage())) {
            return false;
        }
        if (providedLocale.getCountry().length() == 0) {
            return true;
        }
        return providedLocale.getCountry().equals(targetLocale.getCountry());
    }

    private Iterable<ResourceBundle> loadV2LanguagePackBundles(Locale targetLocale, PluginAccessor pluginAccessor) {
        ArrayList<ResourceBundle> v2LanguagePacks = new ArrayList<ResourceBundle>();
        List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
        for (LanguageModuleDescriptor descriptor : descriptors) {
            String location = descriptor.getResourceBundleName();
            Locale providedLocale = ((Language)descriptor.getModule()).getLocale();
            if (!BackingI18n.providedLocaleMatches(providedLocale, targetLocale)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("IGNORING v2 lang pack; targetLocale=" + targetLocale + "; descriptor=" + descriptor.getName() + "; providedLocale=" + providedLocale));
                continue;
            }
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(location, providedLocale, descriptor.getPlugin().getClassLoader(), NO_FALLBACK_CONTROL);
                v2LanguagePacks.add(resourceBundle);
                this.involvedPluginsTracker.trackInvolvedPlugin((ModuleDescriptor)descriptor);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Accepted v2 lang pack; targetLocale=" + targetLocale + "; descriptor=" + descriptor.getName() + "; providedLocale=" + providedLocale));
            }
            catch (MissingResourceException mre) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Failed to get resource bundle " + location + " from module descriptor " + descriptor.getName() + ": " + mre));
            }
        }
        Collections.sort(v2LanguagePacks, RESOURCE_BUNDLE_LOCALE_SORTER);
        return v2LanguagePacks;
    }

    private Iterable<ResourceBundle> loadPluginSourcedBundles(Locale targetLocale, PluginAccessor pluginAccessor) {
        ArrayList<ResourceBundle> pluginBundles = new ArrayList<ResourceBundle>();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            this.loadPluginSourcedBundles(targetLocale, pluginBundles, plugin);
        }
        Collections.sort(pluginBundles, RESOURCE_BUNDLE_LOCALE_SORTER);
        return pluginBundles;
    }

    private void loadPluginSourcedBundles(Locale targetLocale, List<ResourceBundle> pluginBundles, Plugin plugin) {
        for (ResourceDescriptor resourceDescriptor : this.getResourceBundleLocations(plugin)) {
            try {
                String location = resourceDescriptor.getLocation();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(location, targetLocale, plugin.getClassLoader(), NO_FALLBACK_CONTROL);
                if (BackingI18n.providedLocaleMatches(resourceBundle.getLocale(), targetLocale)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Accepted plugin resource; targetLocale=" + targetLocale + "; plugin=" + plugin.getName() + "; descriptor=" + resourceDescriptor.getName() + "; providedLocale=" + resourceBundle.getLocale()));
                    }
                    pluginBundles.add(resourceBundle);
                    this.involvedPluginsTracker.trackInvolvedPlugin(plugin);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("IGNORING plugin resource; targetLocale=" + targetLocale + "; plugin=" + plugin.getName() + "; descriptor=" + resourceDescriptor.getName() + "; providedLocale=" + resourceBundle.getLocale()));
            }
            catch (MissingResourceException mre) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Failed to get resource bundle " + resourceDescriptor.getLocation() + " from resource descriptor " + resourceDescriptor.getName() + ": " + mre));
            }
        }
    }

    private Collection<ResourceDescriptor> getResourceBundleLocations(Plugin plugin) {
        ArrayList<ResourceDescriptor> locations = new ArrayList<ResourceDescriptor>();
        Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)plugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(PLUGIN_RESOURCE_TYPE_I18N)));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(PLUGIN_RESOURCE_TYPE_I18N)));
        }
        return locations;
    }

    private Map<String, String> flattenResourceBundlesToMap(Iterable<ResourceBundle> bundles) {
        HashMap<String, String> map = new HashMap<String, String>(8192);
        for (ResourceBundle bundle : bundles) {
            if (bundle == null) continue;
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                try {
                    map.put(key, bundle.getString(key));
                }
                catch (ClassCastException cce) {
                    this.logFlatteningException(key, bundle, cce);
                }
                catch (MissingResourceException mre) {
                    this.logFlatteningException(key, bundle, mre);
                }
                catch (NullPointerException npe) {
                    this.logFlatteningException(key, bundle, npe);
                }
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private void logFlatteningException(String key, ResourceBundle bundle, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Failed to resolve key " + key + "  from resource bundle " + bundle + ": " + e));
        }
    }

    @Immutable
    static final class ResourceBundleLocaleSorter
    implements Comparator<ResourceBundle> {
        ResourceBundleLocaleSorter() {
        }

        @Override
        public int compare(ResourceBundle bundle1, ResourceBundle bundle2) {
            Locale locale1 = bundle1.getLocale();
            Locale locale2 = bundle2.getLocale();
            if (locale1.getLanguage().length() == 0) {
                return locale2.getLanguage().length() == 0 ? 0 : -1;
            }
            if (locale2.getLanguage().length() == 0) {
                return 1;
            }
            if (locale1.getCountry().length() == 0) {
                return locale2.getCountry().length() == 0 ? 0 : -1;
            }
            if (locale2.getCountry().length() == 0) {
                return 1;
            }
            return 0;
        }
    }

    private class PrefixFunction
    implements Function<String, Set<String>> {
        private PrefixFunction() {
        }

        public Set<String> apply(String prefix) {
            HashSet<String> ret = new HashSet<String>();
            for (String key : BackingI18n.this.translationMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                ret.add(key);
            }
            return Collections.unmodifiableSet(ret);
        }
    }
}

