/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.ProjectActionSupport;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProjectAction
extends ProjectActionSupport {
    private static final Map<String, String> ERROR_FIELD_MAPPINGS = new HashMap<String, String>();
    private String name;
    private String key;
    private String lead;
    private Long avatarId;
    private Long assigneeType;
    private String url;
    private String description;
    private Long notificationScheme;
    private Long permissionScheme;
    private Long issueSecurityScheme;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public Long getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(Long assigneeType) {
        this.assigneeType = assigneeType;
    }

    public String getPrettyAssigneeType(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType(assigneeType);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key.toUpperCase();
    }

    public Long getNotificationScheme() {
        return this.notificationScheme;
    }

    public void setNotificationScheme(Long notificationScheme) {
        this.notificationScheme = notificationScheme;
    }

    public Long getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(Long permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public Long getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public void setIssueSecurityScheme(Long issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
    }

    public Map getAssigneeTypes() {
        return ProjectAssigneeTypes.getAssigneeTypes();
    }

    protected void mapErrorCollection(ErrorCollection errorCollection) {
        Map validationErrors = errorCollection.getErrors();
        for (String key : validationErrors.keySet()) {
            String originalErrorMessage = (String)validationErrors.get(key);
            String newKey = ERROR_FIELD_MAPPINGS.get(key);
            if (newKey != null) {
                this.addError(newKey, originalErrorMessage);
                continue;
            }
            this.addErrorMessage(originalErrorMessage);
        }
        this.addErrorMessages(errorCollection.getErrorMessages());
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    static {
        ERROR_FIELD_MAPPINGS.put("projectDescription", "description");
        ERROR_FIELD_MAPPINGS.put("projectKey", "key");
        ERROR_FIELD_MAPPINGS.put("projectLead", "lead");
        ERROR_FIELD_MAPPINGS.put("projectName", "name");
        ERROR_FIELD_MAPPINGS.put("projectUrl", "url");
    }
}

