/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroup;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.issue.transport.impl.IssueNavigatorActionParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.action.filter.FilterOperationsBean;
import com.atlassian.query.Query;
import com.atlassian.query.order.SearchSort;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class SearchDescriptionEnabledAction
extends IssueActionSupport {
    protected final IssueSearcherManager issueSearcherManager;
    protected FieldValuesHolder fieldValuesHolder;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext authenticationContext;
    private SearchContext searchContext;
    private IssueNavigatorActionParams actionParams;
    private FavouritesService favouritesService;
    private FilterOperationsBean filterOperationsBean;
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;

    public SearchDescriptionEnabledAction(IssueSearcherManager issueSearcherManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        this.issueSearcherManager = issueSearcherManager;
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.favouritesService = ComponentManager.getComponentInstanceOfType(FavouritesService.class);
    }

    public boolean isFilterFavourite() {
        return this.favouritesService.isFavourite(this.getLoggedInUser(), (SharedEntity)this.getSearchRequest());
    }

    protected void populateFieldValuesHolderFromQuery(Query query, FieldValuesHolder fieldValuesHolder) {
        SearchContext context = this.searchService.getSearchContext(this.getLoggedInUser(), query);
        Collection<IssueSearcher<?>> searchers = this.getSearchers();
        for (IssueSearcher<?> searcher : searchers) {
            searcher.getSearchInputTransformer().populateFromQuery(this.getLoggedInUser(), fieldValuesHolder, query, context);
        }
    }

    public Collection getSearcherGroups() {
        return this.issueSearcherManager.getSearcherGroups(this.getSearchContext());
    }

    public String getSearcherViewHtml(IssueSearcher searcher) {
        SearchRequest searchRequest = this.getSearchRequest();
        SearchRenderer searchRenderer = searcher.getSearchRenderer();
        if (searchRequest != null && searchRenderer.isRelevantForQuery(this.getLoggedInUser(), searchRequest.getQuery())) {
            SearchContext searchContext = this.getSearchContext();
            return searchRenderer.getViewHtml(this.getLoggedInUser(), searchContext, this.getFieldValuesHolder(), new HashMap(), (Action)this);
        }
        return "";
    }

    public boolean isSearchRequestFitsNavigator() {
        return this.searchService.doesQueryFitFilterForm(this.getLoggedInUser(), this.getSearchRequest() != null ? this.getSearchRequest().getQuery() : null);
    }

    public boolean isShown(SearcherGroup searcherGroup) {
        return searcherGroup.isShown(this.getLoggedInUser(), this.getSearchContext());
    }

    protected IssueNavigatorActionParams getActionParams() {
        if (this.actionParams == null) {
            this.actionParams = new IssueNavigatorActionParams(ActionContext.getParameters());
        }
        return this.actionParams;
    }

    protected Collection<IssueSearcher<?>> getSearchers() {
        return this.issueSearcherManager.getAllSearchers();
    }

    protected SearchContext getSearchContext() {
        if (this.getActionParams().isUpdateParamsRequired()) {
            String query = this.getActionParams().getFirstValueForKey("jqlQuery");
            if (query != null) {
                return this.getSeachContextFromQueryString(query);
            }
            return this.getActionParams().getSearchContext();
        }
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null) {
            return this.searchService.getSearchContext(this.authenticationContext.getLoggedInUser(), searchRequest.getQuery());
        }
        if (this.searchContext == null) {
            this.searchContext = this.createSearchContext();
        }
        return this.searchContext;
    }

    private SearchContext getSeachContextFromQueryString(String query) {
        SearchService.ParseResult jqlQuery;
        if (StringUtils.isNotBlank((String)query) && (jqlQuery = this.searchService.parseQuery(this.getLoggedInUser(), query)).isValid()) {
            return this.searchService.getSearchContext(this.getLoggedInUser(), jqlQuery.getQuery());
        }
        return this.createSearchContext();
    }

    private SearchContext createSearchContext() {
        Collection visibleProjects = this.permissionManager.getProjects(10, this.authenticationContext.getLoggedInUser());
        if (visibleProjects != null && visibleProjects.size() == 1) {
            return new SearchContextImpl(null, EasyList.build((Object)((GenericValue)visibleProjects.iterator().next()).getLong("id")), null);
        }
        return new SearchContextImpl();
    }

    protected FieldValuesHolder getFieldValuesHolder() {
        if (this.fieldValuesHolder == null) {
            this.fieldValuesHolder = new FieldValuesHolderImpl();
            if (this.getSearchRequest() != null) {
                this.populateFieldValuesHolderFromQuery(this.getSearchRequest().getQuery(), this.fieldValuesHolder);
            }
        }
        return this.fieldValuesHolder;
    }

    public boolean validateSearchFilterIsSavedFilter(SearchRequest searchRequest, String i18n) {
        if (searchRequest.getId() == null) {
            String name = searchRequest.getName();
            this.log.error((Object)("Tried to perform operation on unsaved filter with id:" + searchRequest.getId() + " and name: " + name));
            this.addErrorMessage(this.getText(i18n, name == null ? "" : name));
            return false;
        }
        return true;
    }

    public FilterOperationsBean getFilterOperationsBean() {
        if (this.filterOperationsBean == null) {
            String userName = this.getLoggedInUser() == null ? null : this.getLoggedInUser().getName();
            this.filterOperationsBean = this.createFilterOperationsBean(userName);
        }
        return this.filterOperationsBean;
    }

    protected FilterOperationsBean createFilterOperationsBean(String userName) {
        return FilterOperationsBean.create(this.getSearchRequest(), this.isFilterValid(), userName, false);
    }

    public boolean isFilterValid() {
        SearchRequest searchRequest = this.getSearchRequest();
        return searchRequest == null || !this.searchService.validateQuery(this.getLoggedInUser(), searchRequest.getQuery()).hasAnyErrors();
    }

    public String getSearchRequestJqlString() {
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null) {
            return this.searchService.getJqlString(searchRequest.getQuery());
        }
        return "";
    }

    public List<SearchSort> getSearchSorts() {
        SearchRequest searchRequest = this.getSearchRequest();
        if (searchRequest != null) {
            return this.searchSortUtil.getSearchSorts(searchRequest.getQuery());
        }
        return null;
    }
}

