/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.SequencedCollection;

public abstract class AbstractWorklogAction
extends AbstractIssueSelectAction {
    private Long worklogId;
    private String timeLogged;
    private String startDate;
    private String workType;
    private String newEstimate;
    private String adjustmentAmount;
    private String commentLevel;
    private String comment;
    protected static final String ADJUST_ESTIMATE_AUTO = "auto";
    protected static final String ADJUST_ESTIMATE_NEW = "new";
    protected static final String ADJUST_ESTIMATE_MANUAL = "manual";
    protected String adjustEstimate = "auto";
    protected final WorklogService worklogService;
    protected final CommentService commentService;
    protected final ProjectRoleManager projectRoleManager;
    protected final JiraDurationUtils jiraDurationUtils;
    protected final OutlookDateManager outlookDateManager;
    protected final FieldVisibilityManager fieldVisibilityManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final UserUtil userUtil;
    private CommentVisibility commentVisibility;

    public AbstractWorklogAction(WorklogService worklogService, CommentService commentService, ProjectRoleManager projectRoleManager, JiraDurationUtils jiraDurationUtils, OutlookDateManager outlookDateManager, FieldVisibilityManager fieldVisibilityManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserUtil userUtil) {
        this.worklogService = worklogService;
        this.commentService = commentService;
        this.projectRoleManager = projectRoleManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.outlookDateManager = outlookDateManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.userUtil = userUtil;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEstimate() throws Exception {
        Long estimate = this.getIssueObject().getEstimate();
        return estimate == null ? null : this.jiraDurationUtils.getFormattedDuration(estimate);
    }

    public boolean isTimeTrackingFieldHidden(Issue issue) {
        return this.fieldVisibilityManager.isFieldHidden("timetracking", issue);
    }

    public String getTimeLogged() {
        return this.timeLogged;
    }

    public void setTimeLogged(String timeLogged) {
        this.timeLogged = timeLogged;
    }

    public String getWorkType() {
        return this.workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getNewEstimate() {
        return this.newEstimate;
    }

    public void setNewEstimate(String newEstimate) {
        this.newEstimate = newEstimate;
    }

    public String getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(String adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public String getAdjustEstimate() {
        return this.adjustEstimate;
    }

    public void setAdjustEstimate(String adjustEstimate) {
        this.adjustEstimate = adjustEstimate;
    }

    public boolean isLevelSelected(String visibilityLevel) {
        return this.getCommentLevel() != null && this.getCommentLevel().equals(visibilityLevel);
    }

    public String getSelectedLevelName() {
        if (this.getCommentLevel() == null) {
            return this.getText("security.level.viewable.by.all");
        }
        Collection<ProjectRole> roleLevels = this.getRoleLevels();
        for (ProjectRole roleLevel : roleLevels) {
            if (!this.getCommentLevel().equals("role:" + roleLevel.getId().toString())) continue;
            return this.getText("security.level.restricted.to", TextUtils.htmlEncode((String)roleLevel.getName()));
        }
        Collection groupLevels = this.getGroupLevels();
        for (String groupLevel : groupLevels) {
            if (!this.getCommentLevel().equals("group:" + groupLevel)) continue;
            return this.getText("security.level.restricted.to", TextUtils.htmlEncode((String)groupLevel));
        }
        return this.getText("security.level.viewable.by.all");
    }

    public String getCommentLevel() {
        return this.commentLevel;
    }

    public void setCommentLevel(String commentLevel) {
        this.commentLevel = commentLevel;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Collection getGroupLevels() {
        SequencedCollection groups = this.getLoggedInUser() == null || !this.commentService.isGroupVisiblityEnabled() ? Collections.EMPTY_LIST : this.userUtil.getGroupNamesForUser(this.getLoggedInUser().getName());
        return groups;
    }

    public Collection<ProjectRole> getRoleLevels() {
        Collection<Object> roleLevels = this.commentService.isProjectRoleVisiblityEnabled() ? this.projectRoleManager.getProjectRoles(this.getLoggedInUser(), this.getIssueObject().getProjectObject()) : Collections.emptyList();
        return roleLevels;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    protected CommentVisibility getCommentVisibility() {
        if (this.commentVisibility == null) {
            this.commentVisibility = new CommentVisibility(this.commentLevel);
        }
        return this.commentVisibility;
    }

    protected Date getParsedStartDate() {
        try {
            return this.getStartDate() == null ? null : this.outlookDateManager.getOutlookDate(this.getLocale()).parseDateTimePicker(this.getStartDate());
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected String getFormattedStartDate(Date date) {
        return this.outlookDateManager.getOutlookDate(this.getLocale()).formatDateTimePicker(date);
    }

    public Long getWorklogId() {
        return this.worklogId;
    }

    public void setWorklogId(Long worklogId) {
        this.worklogId = worklogId;
    }

    public String getWorkDescriptionEditHtml() {
        try {
            FieldLayoutItem worklogFieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)this.getIssueObject()).getFieldLayoutItem("worklog");
            String rendererType = worklogFieldLayoutItem != null ? worklogFieldLayoutItem.getRendererType() : null;
            JiraRendererModuleDescriptor rendererDescriptor = this.rendererManager.getRendererForType(rendererType).getDescriptor();
            Map rendererParams = MapBuilder.newBuilder().add((Object)"rows", (Object)"10").add((Object)"cols", (Object)"60").add((Object)"wrap", (Object)"virtual").add((Object)"class", (Object)"long-field").toMutableMap();
            return rendererDescriptor.getEditVM(this.getComment(), this.getIssueObject().getKey(), rendererType, "comment", "comment", rendererParams, false);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Could not render edit template for work description", (Throwable)e);
            return "";
        }
    }
}

