/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;

@WebSudoRequired
public class DeleteWorkflowTransitions
extends JiraWebActionSupport {
    private final JiraWorkflow workflow;
    private final StepDescriptor step;
    private final WorkflowService workflowService;
    private int[] transitionIds;
    private String originatingUrl;

    public DeleteWorkflowTransitions(JiraWorkflow workflow, StepDescriptor step, WorkflowService workflowService) {
        this.workflow = workflow;
        this.step = step;
        this.workflowService = workflowService;
    }

    public String doConfirm() {
        return "confirm";
    }

    protected void doValidation() {
        if (this.transitionIds == null || this.transitionIds.length == 0) {
            this.addError("transitionIds", this.getText("admin.errors.workflows.must.select.transition"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        for (int i = 0; i < this.transitionIds.length; ++i) {
            int transitionId = this.transitionIds[i];
            ActionDescriptor transition = this.step.getAction(transitionId);
            if (transition == null) {
                this.addErrorMessage(this.getText("admin.errors.workflows.cannot.find.transition.with.id", "'" + transitionId + "'"));
                return "error";
            }
            this.step.getActions().remove(transition);
            if (transition.isCommon()) {
                this.step.getCommonActions().remove(new Integer(transition.getId()));
                if (this.workflow.getStepsForTransition(transition).isEmpty()) {
                    this.workflow.getDescriptor().getCommonActions().remove(new Integer(transition.getId()));
                }
            }
            if (!this.step.getActions().isEmpty() || !this.step.getCommonActions().isEmpty()) continue;
            this.step.removeActions();
        }
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.redirectToView();
    }

    private String redirectToView() {
        return this.getRedirect(this.getCancelUrl());
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public StepDescriptor getStep() {
        return this.step;
    }

    public Collection getTransitions() {
        return this.step.getActions();
    }

    public void setTransitionIds(int[] transitionIds) {
        this.transitionIds = transitionIds;
    }

    public Collection getSelectedTransitions() {
        LinkedList<ActionDescriptor> transitions = new LinkedList<ActionDescriptor>();
        if (this.transitionIds != null) {
            for (int i = 0; i < this.transitionIds.length; ++i) {
                transitions.add(this.step.getAction(this.transitionIds[i]));
            }
        }
        return transitions;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public void setOriginatingUrl(String originatingUrl) {
        this.originatingUrl = originatingUrl;
    }

    public String getCancelUrl() {
        if ("viewWorkflowStep".equals(this.getOriginatingUrl())) {
            return "ViewWorkflowStep.jspa?workflowStep=" + this.step.getId() + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowName=" + URLEncoder.encode(this.workflow.getName());
        }
        return "ViewWorkflowSteps.jspa?workflowName=" + URLEncoder.encode(this.workflow.getName()) + "&workflowMode=" + this.getWorkflow().getMode();
    }
}

