/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.whitelist;

import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.jira.bc.portal.GadgetApplinkUpgradeUtil;
import com.atlassian.jira.bc.whitelist.WhitelistService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class ConfigureWhitelist
extends JiraWebActionSupport {
    private final WhitelistService whitelistService;
    private final GadgetApplinkUpgradeUtil gadgetApplinkUpgradeUtil;
    private boolean disableWhitelist;
    private String rules;
    private boolean showUpgrade;
    private boolean whitelistSaved = false;

    public ConfigureWhitelist(WhitelistService whitelistService, GadgetApplinkUpgradeUtil gadgetApplinkUpgradeUtil) {
        this.whitelistService = whitelistService;
        this.gadgetApplinkUpgradeUtil = gadgetApplinkUpgradeUtil;
    }

    public String doDefault() throws Exception {
        WhitelistService.WhitelistResult result;
        if (this.showUpgrade) {
            this.gadgetApplinkUpgradeUtil.disableUpgradeCheck();
        }
        if ((result = this.whitelistService.getRules(this.getJiraServiceContext())).isValid()) {
            this.rules = this.convertToString(result);
            this.disableWhitelist = this.whitelistService.isDisabled();
            return "input";
        }
        return "input";
    }

    protected void doValidation() {
        this.whitelistService.validateUpdateRules(this.getJiraServiceContext(), this.convertToList(this.rules), this.disableWhitelist);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        WhitelistService.WhitelistUpdateValidationResult result = this.whitelistService.validateUpdateRules(this.getJiraServiceContext(), this.convertToList(this.rules), this.disableWhitelist);
        if (result.isValid()) {
            this.rules = this.convertToString(this.whitelistService.updateRules(result));
            this.disableWhitelist = this.whitelistService.isDisabled();
            this.whitelistSaved = true;
        }
        return "success";
    }

    public boolean isDisableWhitelist() {
        return this.disableWhitelist;
    }

    public boolean isWhitelistSaved() {
        return this.whitelistSaved;
    }

    public void setDisableWhitelist(boolean disableWhitelist) {
        this.disableWhitelist = disableWhitelist;
    }

    public String getRules() {
        return this.rules;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public boolean isShowUpgrade() {
        return this.showUpgrade;
    }

    public void setShowUpgrade(boolean showUpgrade) {
        this.showUpgrade = showUpgrade;
    }

    public Map<URI, List<ExternalGadgetSpec>> getGroupedExternalGadgets() {
        return this.gadgetApplinkUpgradeUtil.getExternalGadgetsRequiringUpgrade();
    }

    private List<String> convertToList(String rules) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] ruleStrings = StringUtils.split((String)rules, null);
        if (ruleStrings != null) {
            for (String ruleString : ruleStrings) {
                if (!StringUtils.isNotBlank((String)ruleString)) continue;
                ret.add(ruleString);
            }
        }
        return ret;
    }

    private String convertToString(WhitelistService.WhitelistResult result) {
        StringBuilder builder = new StringBuilder();
        for (String rule : result.getRules()) {
            builder.append(rule).append("\n");
        }
        return builder.toString();
    }
}

