/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryBrowser;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.vcs.viewcvs.ViewCvsBrowser;
import com.atlassian.jira.web.action.admin.vcs.RepositoryActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class AddRepository
extends RepositoryActionSupport {
    private Map projects = new HashMap();

    public AddRepository(RepositoryManager repositoryManager, CvsRepositoryUtil cvsRepositoryUtil) {
        super(repositoryManager, cvsRepositoryUtil);
    }

    @Override
    public String doDefault() throws Exception {
        this.setFetchLog(true);
        if (this.isSystemAdministrator()) {
            return "input";
        }
        return "error";
    }

    protected void doValidation() {
        if (!this.isSystemAdministrator()) {
            this.addErrorMessage(this.getText("admin.errors.no.perm.when.creating"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.you.must.specify.a.name.for.the.repository"));
        } else if (this.getRepositoryManager().getRepository(this.getName()) != null) {
            this.addError("name", this.getText("admin.errors.another.repository.with.this.name.already.exists"));
        }
        this.validateRepositoryParameters();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Properties cvsProps = new Properties();
        cvsProps.setProperty("cvslogfilepath", this.getLogFilePath());
        cvsProps.setProperty("cvsroot", this.getCvsRoot());
        cvsProps.setProperty("cvsmodulename", this.getModuleName());
        if (this.getPassword() != null) {
            cvsProps.setProperty("cvspassword", this.getPassword());
        }
        cvsProps.setProperty("cvsfetchlog", String.valueOf(this.isFetchLog()));
        cvsProps.setProperty("cvstimeout", String.valueOf(this.getTimeoutMillis()));
        try {
            if (TextUtils.stringSet((String)this.getRepositoryBrowserURL())) {
                cvsProps.setProperty("repositorybrowsertype", "VIEW_CVS");
                cvsProps.setProperty("viewcvsbaseurl", this.getRepositoryBrowserURL());
                cvsProps.setProperty("viewcvsrootparameter", this.getRepositoryBrowserRootParam());
            }
            this.getRepositoryManager().createRepository("cvs", this.getName(), this.getDescription(), cvsProps);
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred while creating the repository.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.occured.when.creating"));
            return this.getResult();
        }
        return this.getRedirect("ViewRepositories.jspa");
    }

    public Collection getProjects(Repository repository) {
        if (!this.projects.containsKey(repository.getId())) {
            try {
                this.projects.put(repository.getId(), this.getRepositoryManager().getProjectsForRepository(repository));
            }
            catch (GenericEntityException e) {
                this.log.error((Object)("Error while retrieving projects for repository '" + repository + "'."), (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.occured.when.retrieving", repository));
                return Collections.EMPTY_LIST;
            }
        }
        return (Collection)this.projects.get(repository.getId());
    }

    public String getViewCVSBaseUrl(Repository repository) {
        RepositoryBrowser repositoryBrowser = repository.getRepositoryBrowser();
        if (repositoryBrowser != null && "VIEW_CVS".equals(repositoryBrowser.getType())) {
            ViewCvsBrowser viewCvsBrowser = (ViewCvsBrowser)repositoryBrowser;
            return viewCvsBrowser.getBaseURL();
        }
        return "";
    }

    public String getViewCVSRootParameter(Repository repository) {
        RepositoryBrowser repositoryBrowser = repository.getRepositoryBrowser();
        if (repositoryBrowser != null && "VIEW_CVS".equals(repositoryBrowser.getType())) {
            ViewCvsBrowser viewCvsBrowser = (ViewCvsBrowser)repositoryBrowser;
            return viewCvsBrowser.getRootParameter();
        }
        return "";
    }

    public Collection getRepositories() throws GenericEntityException {
        ArrayList<Repository> repositories = new ArrayList<Repository>(this.getRepositoryManager().getRepositories());
        Collections.sort(repositories);
        return repositories;
    }

    public boolean isDeletable(Repository repository) {
        try {
            return this.getRepositoryManager().getProjectsForRepository(repository).isEmpty();
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred while retrieving projects for repository '" + repository + "'."), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.occured.when.retrieving", repository));
            return false;
        }
    }
}

