/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserPasswordActionHelper;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import com.opensymphony.util.TextUtils;

public class SetPassword
extends ViewUser {
    private String password;
    private String confirm;
    private final UserUtil userUtil;

    public SetPassword(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserUtil userUtil, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (!this.isHasPermission(0)) {
            this.addErrorMessage(this.getText("admin.errors.must.be.admin.to.set.password"));
        }
        if (!this.isRemoteUserPermittedToEditSelectedUser()) {
            this.addErrorMessage(this.getText("admin.errors.must.be.sysadmin.to.set.sysadmin.password"));
        }
        if (!TextUtils.stringSet((String)this.password)) {
            this.addError("password", this.getText("admin.errors.must.specify.a.password"));
        } else if (!this.password.equals(this.confirm)) {
            this.addError("confirm", this.getText("admin.errors.two.passwords.do.not.match"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        new UserPasswordActionHelper((JiraWebActionSupport)this, this.userUtil).setPassword(this.getUser(), this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return this.getRedirect("/secure/admin/user/ViewUser.jspa?name=" + JiraUrlCodec.encode((String)this.getName()) + "&showPasswordUpdateMsg=true");
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}

