/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.distiller;

import com.atlassian.jira.bc.scheme.distiller.SchemeDistillerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.scheme.distiller.AbstractMergeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemeMergeAction
extends AbstractMergeAction {
    private String[] selectedDistilledSchemes;

    public SchemeMergeAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties, SchemeDistillerService schemeDistiller) {
        super(schemeManagerFactory, schemeFactory, applicationProperties, schemeDistiller);
    }

    public String doDefault() throws Exception {
        this.getDistilledSchemeResults();
        return "input";
    }

    protected void doValidation() {
        Map params = ActionContext.getParameters();
        this.setSelectedStateOnDistilledResults(false);
        if (this.selectedDistilledSchemes == null || this.selectedDistilledSchemes.length == 0) {
            this.addErrorMessage(this.getText("admin.scheme.merge.action.must.select.one.scheme"));
        }
        List newSchemeNames = this.validateInputFields(params);
        this.checkForDuplicates(newSchemeNames);
    }

    protected String doExecute() throws Exception {
        this.setSelectedStateOnDistilledResults(true);
        return this.forceRedirect("SchemeMergePreview!default.jspa?selectedSchemeType=" + this.getSelectedSchemeType() + "&typeOfSchemesToDisplay=" + this.getTypeOfSchemesToDisplay());
    }

    public String getEditPage() {
        String editPage = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditNotifications";
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditPermissions";
        }
        return editPage;
    }

    public int getTotalDistilledFromSchemes() {
        int i = 0;
        for (DistilledSchemeResult distilledSchemeResult : this.distilledSchemeResults.getDistilledSchemeResults()) {
            i += distilledSchemeResult.getOriginalSchemes().size();
        }
        return i;
    }

    public String[] getSelectedDistilledSchemes() {
        return this.selectedDistilledSchemes;
    }

    public void setSelectedDistilledSchemes(String[] selectedDistilledSchemes) {
        this.selectedDistilledSchemes = selectedDistilledSchemes;
    }

    public List getSelectedDistilledSchemesAsList() {
        if (this.selectedDistilledSchemes == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.selectedDistilledSchemes);
    }

    private List validateInputFields(Map params) {
        ArrayList<String> newSchemeNames = new ArrayList<String>();
        for (DistilledSchemeResult distilledSchemeResult : this.getDistilledSchemeResults().getDistilledSchemeResults()) {
            Scheme scheme = distilledSchemeResult.getResultingScheme();
            if (!this.getSelectedDistilledSchemesAsList().contains(scheme.getName())) continue;
            String[] newSchemeNamesParam = (String[])params.get(scheme.getName());
            if (newSchemeNamesParam == null || newSchemeNamesParam[0].trim().length() == 0) {
                this.addError(scheme.getName(), this.getText("admin.scheme.merge.action.name.for.scheme"));
                continue;
            }
            String newSchemeName = newSchemeNamesParam[0].trim();
            newSchemeNames.add(newSchemeName);
            distilledSchemeResult.setResultingSchemeTempName(newSchemeName);
        }
        return newSchemeNames;
    }

    private void setSelectedStateOnDistilledResults(boolean nukeTempName) {
        for (DistilledSchemeResult distilledSchemeResult : this.getDistilledSchemeResults().getDistilledSchemeResults()) {
            if (this.getSelectedDistilledSchemesAsList().contains(distilledSchemeResult.getResultingScheme().getName())) {
                distilledSchemeResult.setSelected(true);
                continue;
            }
            distilledSchemeResult.setSelected(false);
            if (!nukeTempName) continue;
            distilledSchemeResult.setResultingSchemeTempName("");
        }
    }

    private void checkForDuplicates(List newSchemeNames) {
        for (DistilledSchemeResult distilledSchemeResult : this.getDistilledSchemeResults().getDistilledSchemeResults()) {
            Scheme scheme = distilledSchemeResult.getResultingScheme();
            if (!this.getSelectedDistilledSchemesAsList().contains(scheme.getName())) continue;
            String resultingSchemeTempName = distilledSchemeResult.getResultingSchemeTempName();
            if (CollectionUtils.countMatches((Collection)newSchemeNames, (Predicate)PredicateUtils.equalPredicate((Object)resultingSchemeTempName)) > 1) {
                this.addError(scheme.getName(), this.getText("admin.scheme.merge.action.dup.name"));
            }
            this.schemeDistiller.isValidNewSchemeName(this.getLoggedInUser(), scheme.getName(), resultingSchemeTempName, this.getSelectedSchemeType(), (ErrorCollection)this);
        }
    }
}

