/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractFieldLayoutAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class EditFieldLayout
extends AbstractFieldLayoutAction {
    public EditFieldLayout(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                this.setFieldLayoutName(this.getFieldLayout().getName());
                this.setFieldLayoutDescription(this.getFieldLayout().getDescription());
            }
        }
        if (!this.invalidInput()) {
            return "input";
        }
        return "error";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                this.validateName();
                if (!this.invalidInput()) {
                    for (FieldLayout fieldLayout : this.getFieldLayouts()) {
                        if (this.getId().equals(fieldLayout.getId()) || !this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                        this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                    }
                }
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getFieldLayout().setName(this.getFieldLayoutName());
        this.getFieldLayout().setDescription(this.getFieldLayoutDescription());
        this.getFieldLayoutManager().storeEditableFieldLayout(this.getFieldLayout());
        return this.redirectToView();
    }
}

