/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.darkfeatures;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class SiteDarkFeatures
extends JiraWebActionSupport {
    private String featureKey;
    private final FeatureManager featureManager;
    private DarkFeatures darkFeatures;
    private final PermissionManager permissionManager;

    public SiteDarkFeatures(FeatureManager featureManager, PermissionManager permissionManager) {
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(0, this.getLoggedInUser());
    }

    public String doDefault() throws Exception {
        if (!this.isPermitted()) {
            return "securitybreach";
        }
        return "success";
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (!this.isPermitted()) {
            return "securitybreach";
        }
        if (StringUtils.isNotBlank((String)this.featureKey)) {
            this.featureManager.enableSiteDarkFeature(this.featureKey.trim());
        }
        this.featureKey = "";
        return "success";
    }

    @RequiresXsrfCheck
    public String doRemove() {
        if (StringUtils.isNotBlank((String)this.featureKey)) {
            this.featureManager.disableSiteDarkFeature(this.featureKey.trim());
        }
        this.featureKey = "";
        return "success";
    }

    public List<String> getSystemEnabledFeatures() {
        ArrayList enabledFeatures = Lists.newArrayList(this.getDarkFeatures().getSystemEnabledFeatures());
        Collections.sort(enabledFeatures);
        return enabledFeatures;
    }

    public List<String> getSiteEnabledFeatures() {
        ArrayList enabledFeatures = Lists.newArrayList(this.getDarkFeatures().getSiteEnabledFeatures());
        Collections.sort(enabledFeatures);
        return enabledFeatures;
    }

    private DarkFeatures getDarkFeatures() {
        if (this.darkFeatures == null) {
            this.darkFeatures = this.featureManager.getDarkFeatures();
        }
        return this.darkFeatures;
    }

    public void setFeatureKey(String featureKey) {
        this.featureKey = featureKey;
    }

    public boolean isEnabled(String featureKey) {
        return this.featureManager.isEnabled(featureKey);
    }

    public String getFeatureKey() {
        return this.featureKey;
    }
}

