/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class FieldVisibilityManagerImpl
implements FieldVisibilityManager {
    private static final Logger log = Logger.getLogger(FieldVisibilityManagerImpl.class);
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;

    public FieldVisibilityManagerImpl(FieldManager fieldManager, ProjectManager projectManager) {
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
    }

    public boolean isFieldHidden(User remoteUser, String id) {
        return this.fieldManager.isFieldHidden(remoteUser, id);
    }

    public boolean isFieldVisible(User remoteUser, String id) {
        return !this.fieldManager.isFieldHidden(remoteUser, id);
    }

    public boolean isFieldHidden(String fieldId, Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        Project project = issue.getProjectObject();
        IssueType issueType = issue.getIssueTypeObject();
        if (issueType == null || project == null) {
            if (issueType == null) {
                log.warn((Object)("Issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' has a null issue type, returning true for isFieldHidden check."));
            }
            if (project == null) {
                log.warn((Object)("Issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' has a null project, returning true for isFieldHidden check."));
            }
            return true;
        }
        return this.isFieldHidden(project.getId(), fieldId, issueType.getId());
    }

    public boolean isFieldVisible(String fieldId, Issue issue) {
        return !this.isFieldHidden(fieldId, issue);
    }

    public boolean isCustomFieldHidden(Long projectId, Long customFieldId, String issueTypeId) {
        return this.isFieldHidden(projectId, "customfield_" + customFieldId, issueTypeId);
    }

    public boolean isCustomFieldVisible(Long projectId, Long customFieldId, String issueTypeId) {
        return this.isFieldVisible(projectId, "customfield_" + customFieldId, issueTypeId);
    }

    public boolean isFieldHidden(Long projectId, String fieldId, Long issueTypeId) {
        return this.isFieldHidden(projectId, fieldId, issueTypeId.toString());
    }

    public boolean isFieldVisible(Long projectId, String fieldId, Long issueTypeId) {
        return this.isFieldVisible(projectId, fieldId, issueTypeId.toString());
    }

    public boolean isFieldHidden(Long projectId, String fieldId, String issueTypeId) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null.");
        }
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        Project project = this.projectManager.getProjectObj(projectId);
        if (TextUtils.stringSet((String)issueTypeId)) {
            FieldLayoutManager layoutManager = this.fieldManager.getFieldLayoutManager();
            if ("all".equals(issueTypeId)) {
                SubTaskManager subTaskManager = ComponentManager.getInstance().getSubTaskManager();
                List issueTypes = subTaskManager.isSubTasksEnabled() ? constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-4"})) : constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-2"}));
                for (String issueType : issueTypes) {
                    FieldLayout fieldLayout = layoutManager.getFieldLayout(project, issueType);
                    if (fieldLayout != null && !fieldLayout.isFieldHidden(fieldId)) continue;
                    return true;
                }
                return false;
            }
            FieldLayout fieldLayout = layoutManager.getFieldLayout(project, issueTypeId);
            return fieldLayout == null || fieldLayout.isFieldHidden(fieldId);
        }
        log.warn((Object)("Unable to determine field visibility with project with id '" + projectId + "', issue type with id '" + issueTypeId + "' and field with id '" + fieldId + "'."));
        return true;
    }

    public boolean isFieldVisible(Long projectId, String fieldId, String issueTypeId) {
        return !this.isFieldHidden(projectId, fieldId, issueTypeId);
    }

    public boolean isFieldHiddenInAllSchemes(Long projectId, String fieldId, List<String> issueTypes) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null");
        }
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        Project project = this.projectManager.getProjectObj(projectId);
        FieldLayoutManager layoutManager = this.fieldManager.getFieldLayoutManager();
        if (issueTypes == null || issueTypes.isEmpty()) {
            SubTaskManager subTaskManager = ComponentManager.getInstance().getSubTaskManager();
            issueTypes = subTaskManager.isSubTasksEnabled() ? constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-4"})) : constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-2"}));
            for (String issueType : issueTypes) {
                FieldLayout fieldLayout = layoutManager.getFieldLayout(project, issueType);
                if (fieldLayout == null || fieldLayout.isFieldHidden(fieldId)) continue;
                return false;
            }
            return true;
        }
        for (String issueType : issueTypes) {
            FieldLayout fieldLayout = layoutManager.getFieldLayout(project, issueType);
            if (fieldLayout == null || fieldLayout.isFieldHidden(fieldId)) continue;
            return false;
        }
        return true;
    }

    public boolean isFieldHiddenInAllSchemes(Long projectId, String fieldId) {
        return this.isFieldHiddenInAllSchemes(projectId, fieldId, Collections.<String>emptyList());
    }

    public boolean isFieldHiddenInAllSchemes(String fieldId, SearchContext context, User user) {
        if (context.isForAnyProjects()) {
            return this.isFieldHidden(user, fieldId);
        }
        List projectIds = context.getProjectIds();
        for (Long projectId : projectIds) {
            if (this.projectManager.getProjectObj(projectId) != null) {
                boolean hidden = this.isFieldHiddenInAllSchemes(projectId, fieldId, context.getIssueTypeIds());
                if (hidden) continue;
                return false;
            }
            log.warn((Object)("Unable to find project with id " + projectId));
        }
        return true;
    }
}

