/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.util.JiraUtils;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;

public class JiraTypeUtils {
    private static final Logger log = Logger.getLogger(JiraTypeUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadTypes(String resource, Class typeClass) {
        ListOrderedMap loadedTypes = new ListOrderedMap();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)resource, (Class)typeClass);
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("type");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                String id = action.getAttribute("id");
                String className = action.getElement("class").getTextString();
                try {
                    loadedTypes.put(id, JiraUtils.loadComponent(className, typeClass));
                }
                catch (Exception e) {
                    log.error((Object)("Exception loading type: " + className), (Throwable)e);
                }
            }
            ListOrderedMap listOrderedMap = loadedTypes;
            return listOrderedMap;
        }
        catch (ParseException e) {
            log.error((Object)("Parse exception parsing: " + resource), (Throwable)e);
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)("Could not close " + resource + " inputStream"));
            }
        }
    }
}

