/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.GlobalUserPreferencesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GlobalUserPreferencesUtilImpl
implements GlobalUserPreferencesUtil {
    private final OfBizDelegator ofBizDelegator;
    private final UserPreferencesManager userPreferencesManager;

    public GlobalUserPreferencesUtilImpl(OfBizDelegator ofBizDelegator, UserPreferencesManager userPreferencesManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.userPreferencesManager = userPreferencesManager;
    }

    @Override
    public long getTotalUpdateUserCountMailMimeType(String mimetype) {
        List<GenericValue> valExternalEntity = this.getEntriesForMailWithMimetype(mimetype, "ExternalEntity");
        return valExternalEntity.size();
    }

    @Override
    public void updateUserMailMimetypePreference(String mimetype) throws GenericEntityException {
        List<GenericValue> vals = this.getEntriesForMailWithMimetype(mimetype, "ExternalEntity");
        ArrayList<Long> keys = new ArrayList<Long>();
        for (GenericValue genericValue : vals) {
            keys.add(genericValue.getLong("id"));
        }
        this.ofBizDelegator.bulkUpdateByPrimaryKey("OSPropertyString", EasyMap.build((Object)"value", (Object)mimetype), keys);
        this.userPreferencesManager.clearCache();
    }

    @Override
    public long getUserLocalePreferenceCount(String localeCode) {
        Collection vals = this.getUserLocalePreferenceEntries(localeCode);
        return vals.size();
    }

    @Override
    public Collection getUserLocalePreferenceList(String localeCode) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Collection matches = this.getUserLocalePreferenceEntries(localeCode);
        for (GenericValue genericValue : matches) {
            GenericValue user = this.ofBizDelegator.findByPrimaryKey("OSPropertyEntry", EasyMap.build((Object)"id", (Object)genericValue.getString("id")));
            GenericValue userGV = this.ofBizDelegator.findByPrimaryKey("ExternalEntity", EasyMap.build((Object)"id", (Object)user.getString("entityId")));
            userNameList.add(userGV.getString("name"));
        }
        return userNameList;
    }

    private Collection getUserLocalePreferenceEntries(String localeCode) {
        ArrayList<GenericValue> matches = new ArrayList<GenericValue>();
        List vals = this.ofBizDelegator.findByAnd("OSUserPropertySetView", EasyMap.build((Object)"propertyKey", (Object)"jira.user.locale", (Object)"entityName", (Object)"ExternalEntity"));
        for (GenericValue genericValue : vals) {
            if (!localeCode.equals(genericValue.getString("propertyValue"))) continue;
            matches.add(genericValue);
        }
        return matches;
    }

    private List<GenericValue> getEntriesForMailWithMimetype(String mimetype, String entityType) {
        String updateMimetype = mimetype.equalsIgnoreCase("html") ? "text" : "html";
        ArrayList<GenericValue> matches = new ArrayList<GenericValue>();
        List vals = this.ofBizDelegator.findByAnd("OSUserPropertySetView", EasyMap.build((Object)"propertyKey", (Object)"user.notifications.mimetype", (Object)"entityName", (Object)entityType));
        for (GenericValue genericValue : vals) {
            if (!updateMimetype.equals(genericValue.getString("propertyValue"))) continue;
            matches.add(genericValue);
        }
        return matches;
    }
}

