/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.user.OfbizExternalEntityStore;
import com.atlassian.jira.user.util.UserUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build756
extends AbstractUpgradeTask {
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build756.class);
    private static final String ENTITY_TYPE = OfbizExternalEntityStore.class.getName();
    private static final String NAME = "name";
    private final OfBizDelegator delegator;
    private final UserUtil userUtil;

    public UpgradeTask_Build756(OfBizDelegator delegator, UserUtil userUtil) {
        super(false);
        this.delegator = delegator;
        this.userUtil = userUtil;
    }

    @Override
    public String getBuildNumber() {
        return "756";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Map<String, Object> externalEntityParameters = new PrimitiveMap.Builder().add("type", ENTITY_TYPE).toMap();
        List entities = this.delegator.findByAnd("ExternalEntity", externalEntityParameters);
        if (entities != null) {
            LOG.info((Object)String.format("Analysing %d External Entities...", entities.size()));
            for (GenericValue gv : entities) {
                String name = gv.getString(NAME);
                User user = this.userUtil.getUser(name);
                if (user != null && name.equals(user.getName())) {
                    gv.setString(NAME, IdentifierUtils.toLowerCase((String)name));
                    gv.store();
                    continue;
                }
                gv.remove();
            }
        }
    }
}

