/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.velocity.VelocityTemplateCache;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.velocity.JiraVelocityManager;
import com.atlassian.velocity.VelocityManager;
import com.atlassian.velocity.htmlsafe.directive.DefaultDirectiveChecker;
import com.atlassian.velocity.htmlsafe.directive.DirectiveChecker;
import com.atlassian.velocity.htmlsafe.event.referenceinsertion.EnableHtmlEscapingDirectiveHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.context.Context;

public class DefaultVelocityTemplatingEngine
implements VelocityTemplatingEngine {
    private final VelocityManager velocityManager;
    private final ApplicationProperties applicationProperties;
    private final DirectiveChecker directiveChecker;

    public DefaultVelocityTemplatingEngine(VelocityManager velocityManager, ApplicationProperties applicationProperties) {
        this(velocityManager, applicationProperties, null);
    }

    public DefaultVelocityTemplatingEngine(VelocityManager velocityManager, ApplicationProperties applicationProperties, @Nullable VelocityTemplateCache velocityTemplateCache) {
        this.velocityManager = velocityManager;
        this.applicationProperties = applicationProperties;
        this.directiveChecker = velocityTemplateCache == null ? new DefaultDirectiveChecker() : new CachingDirectiveChecker(velocityTemplateCache);
    }

    public VelocityTemplatingEngine.RenderRequest render(TemplateSource source) {
        return new DefaultRenderRequest(source);
    }

    private EventCartridge createDefaultCartridge() {
        EnableHtmlEscapingDirectiveHandler handler = new EnableHtmlEscapingDirectiveHandler();
        handler.setDirectiveChecker(this.directiveChecker);
        EventCartridge cartridge = new EventCartridge();
        cartridge.addEventHandler((EventHandler)handler);
        return cartridge;
    }

    private static class CachingDirectiveChecker
    implements DirectiveChecker {
        private final VelocityTemplateCache velocityTemplateCache;

        public CachingDirectiveChecker(@Nonnull VelocityTemplateCache velocityTemplateCache) {
            this.velocityTemplateCache = velocityTemplateCache;
        }

        public boolean isPresent(String directiveName, Template template) {
            return this.velocityTemplateCache.isDirectivePresent(directiveName, template);
        }
    }

    class DefaultRenderRequest
    implements VelocityTemplatingEngine.RenderRequest {
        private final TemplateSource source;
        private VelocityContext context = this.createContextFrom(Collections.<String, Object>emptyMap());

        public DefaultRenderRequest(TemplateSource source) {
            Preconditions.checkNotNull((Object)source);
            this.source = source;
        }

        public VelocityTemplatingEngine.RenderRequest applying(Map<String, Object> parameters) {
            this.context = this.createContextFrom(parameters);
            return this;
        }

        public VelocityTemplatingEngine.RenderRequest applying(VelocityContext context) {
            this.context = context;
            return this;
        }

        public String asPlainText() {
            if (this.source instanceof TemplateSource.File) {
                TemplateSource.File template = (TemplateSource.File)this.source;
                return DefaultVelocityTemplatingEngine.this.velocityManager.getEncodedBody(template.getPath(), "", this.getBaseUrl(), DefaultVelocityTemplatingEngine.this.applicationProperties.getEncoding(), (Context)this.context);
            }
            if (this.source instanceof TemplateSource.Fragment) {
                TemplateSource.Fragment fragment = (TemplateSource.Fragment)this.source;
                return ((JiraVelocityManager)DefaultVelocityTemplatingEngine.this.velocityManager).getEncodedBodyForContent(fragment.getContent(), (Context)this.context);
            }
            return "";
        }

        public String asHtml() {
            if (this.source instanceof TemplateSource.File) {
                TemplateSource.File template = (TemplateSource.File)this.source;
                this.context.attachEventCartridge(DefaultVelocityTemplatingEngine.this.createDefaultCartridge());
                return DefaultVelocityTemplatingEngine.this.velocityManager.getEncodedBody(template.getPath(), "", this.getBaseUrl(), DefaultVelocityTemplatingEngine.this.applicationProperties.getEncoding(), (Context)this.context);
            }
            if (this.source instanceof TemplateSource.Fragment) {
                TemplateSource.Fragment fragment = (TemplateSource.Fragment)this.source;
                this.context.attachEventCartridge(DefaultVelocityTemplatingEngine.this.createDefaultCartridge());
                return ((JiraVelocityManager)DefaultVelocityTemplatingEngine.this.velocityManager).getEncodedBodyForContent(fragment.getContent(), (Context)this.context);
            }
            return "";
        }

        private String getBaseUrl() {
            if (ExecutingHttpRequest.get() != null) {
                return ExecutingHttpRequest.get().getContextPath();
            }
            return DefaultVelocityTemplatingEngine.this.applicationProperties.getString("jira.baseurl");
        }

        private VelocityContext createContextFrom(Map<String, Object> suppliedParameters) {
            Map contextParameters = CompositeMap.of(suppliedParameters, Collections.singletonMap("baseurl", this.getBaseUrl()));
            return new VelocityContext(CompositeMap.of((Map)Maps.newHashMap(), (Map)contextParameters));
        }
    }
}

