/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.SystemTenantJiraHomeLocator;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.impl.TenantComponentMap;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class SystemTenant
implements TenantComponentMap {
    private final Map<MultiTenantComponentMap, Object> objectMap = CopyOnWriteMap.builder().newHashMap();
    private final Map<Class<?>, Object> configMap;
    private final SystemTenantJiraHomeLocator jiraHomeLocator = new SystemTenantJiraHomeLocator();

    SystemTenant(Map<Class<?>, Object> configMap) {
        this.configMap = CopyOnWriteMap.builder().addAll(configMap).newHashMap();
    }

    public <T> void putObject(MultiTenantComponentMap<T> key, T value) {
        this.objectMap.put(key, value);
    }

    public boolean hasObject(MultiTenantComponentMap key) {
        return this.objectMap.containsKey(key);
    }

    public <T> T getObject(MultiTenantComponentMap<T> key) {
        return (T)this.objectMap.get(key);
    }

    public <T> T removeObject(MultiTenantComponentMap<T> key) {
        return (T)this.objectMap.remove(key);
    }

    public String getName() {
        return "_jiraSystemTenant";
    }

    public String getHomeDir() {
        return this.jiraHomeLocator.getJiraHome();
    }

    public Collection<String> getHostnames() {
        return Collections.singleton("localhost");
    }

    public <B> B getConfig(Class<B> beanClazz) {
        return (B)this.configMap.get(beanClazz);
    }

    public void putConfig(Class configClass, Object configObject) {
        this.configMap.put(configClass, configObject);
    }
}

