/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.util.AbstractGroupToSchemeMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GroupToIssueSecuritySchemeMapper
extends AbstractGroupToSchemeMapper {
    private IssueSecurityLevelManager issueSecurityLevelManager;

    public GroupToIssueSecuritySchemeMapper(IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager) throws GenericEntityException {
        super((SchemeManager)issueSecuritySchemeManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.setGroupMapping(this.init());
    }

    @Override
    protected Map init() throws GenericEntityException {
        HashMap mapping = new HashMap();
        if (this.getSchemeManager() != null && this.issueSecurityLevelManager != null) {
            List schemes = this.getSchemeManager().getSchemes();
            for (int i = 0; i < schemes.size(); ++i) {
                GenericValue issueSecurityScheme = (GenericValue)schemes.get(i);
                List schemeIssueSecurityLevels = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(issueSecurityScheme.getLong("id"));
                for (int j = 0; j < schemeIssueSecurityLevels.size(); ++j) {
                    GenericValue issueSecurityLevel = (GenericValue)schemeIssueSecurityLevels.get(j);
                    List levelPermissions = this.getSchemeManager().getEntities(issueSecurityScheme, "group", issueSecurityLevel.getLong("id"));
                    for (int k = 0; k < levelPermissions.size(); ++k) {
                        GenericValue levelPermission = (GenericValue)levelPermissions.get(k);
                        this.addEntry(mapping, levelPermission.getString("parameter"), issueSecurityScheme);
                    }
                }
            }
        }
        return mapping;
    }
}

