/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.auth.trustedapps.UserNameTransformer;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.Tenant;
import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.seraph.filter.TrustedApplicationsFilter;
import java.security.Principal;

public class TrustedApplicationFilter
extends TrustedApplicationsFilter {
    public TrustedApplicationFilter() {
        super((TrustedApplicationsManager)new DelegateManager(), (UserResolver)new OSUserResolver());
    }

    private static class UserNameTransformerMultiTenantCreator
    implements MultiTenantCreator<UserNameTransformer> {
        private UserNameTransformerMultiTenantCreator() {
        }

        public UserNameTransformer create(Tenant tenant) {
            UserNameTransformer.Factory factory = new UserNameTransformer.Factory(new UserNameTransformer.ApplicationPropertiesClassNameRetriever(ComponentAccessor.getApplicationProperties()));
            UserNameTransformer transformer = factory.get();
            Null.not("transformer", transformer);
            return transformer;
        }
    }

    private static class DelegateManager
    implements TrustedApplicationsManager {
        private DelegateManager() {
        }

        public TrustedApplication getTrustedApplication(String id) {
            return this.getDelegate().getTrustedApplication(id);
        }

        public CurrentApplication getCurrentApplication() {
            return this.getDelegate().getCurrentApplication();
        }

        private TrustedApplicationsManager getDelegate() {
            return ComponentManager.getInstance().getTrustedApplicationsManager();
        }
    }

    private static class OSUserResolver
    implements UserResolver {
        private final MultiTenantComponentMap<UserNameTransformer> transformers = MultiTenantContext.getFactory().createComponentMap((MultiTenantCreator)new UserNameTransformerMultiTenantCreator());

        public Principal resolve(ApplicationCertificate certificate) {
            Null.not("ApplicationCertificate", certificate);
            String name = ((UserNameTransformer)this.transformers.get()).transform(certificate.getUserName());
            return ComponentAccessor.getUserUtil().getUser(name);
        }
    }
}

