/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractDeleteScheme
extends AbstractSchemeAwareAction {
    private boolean confirmed = false;
    private String name;
    private String description = null;

    public String doDefault() throws Exception {
        if (this.getScheme() == null) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.nonexistent.scheme"));
            return "input";
        }
        this.name = this.getScheme().getString("name");
        if (TextUtils.stringSet((String)this.getScheme().getString("description"))) {
            this.description = this.getScheme().getString("description");
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getSchemeId() == null) {
            this.addError("schemeId", this.getText("admin.errors.deletescheme.no.scheme.specified"));
        }
        if (this.getSchemeManager().getDefaultSchemeObject() != null && this.getSchemeManager().getDefaultSchemeObject().getId().equals(this.getSchemeId())) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.cannot.delete.default"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.deletescheme.confirmation"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.getScheme() != null) {
            List<GenericValue> projects = this.getProjects(this.getScheme());
            for (GenericValue project : projects) {
                this.getSchemeManager().removeSchemesFromProject(project);
                this.getSchemeManager().addDefaultSchemeToProject(project);
            }
            this.getSchemeManager().deleteScheme(this.getSchemeId());
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectURL());
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<GenericValue> getProjects(GenericValue scheme) throws GenericEntityException {
        return ManagerFactory.getPermissionSchemeManager().getProjects(scheme);
    }
}

