/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.render;

import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.render.Encoder;
import com.atlassian.jira.render.NoOpEncoder;
import com.atlassian.jira.render.StrictEncoder;
import com.atlassian.jira.web.HttpRequestLocal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SwitchingEncoder
implements Encoder {
    private final FeatureManager featureManager;
    private final HttpRequestLocal<Encoder> requestEncoder = new HttpRequestLocal<Encoder>(SwitchingEncoder.class.getName()){

        @Override
        protected Encoder initialValue() {
            return SwitchingEncoder.this.createEncoder();
        }
    };

    public SwitchingEncoder(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Nonnull
    public String encodeForHtml(@Nullable Object input) {
        Encoder encoder = this.requestEncoder.get();
        if (encoder == null) {
            encoder = this.createEncoder();
        }
        return encoder.encodeForHtml(input);
    }

    @Nonnull
    protected Encoder createEncoder() {
        if (this.featureManager.isEnabled(CoreFeatures.ON_DEMAND)) {
            return new StrictEncoder();
        }
        return new NoOpEncoder();
    }
}

